/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.packets;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.events.player.PlayerHoldsItemEvent;
import com.denizenscript.denizen.events.player.PlayerReceivesActionbarScriptEvent;
import com.denizenscript.denizen.events.player.PlayerReceivesMessageScriptEvent;
import com.denizenscript.denizen.events.player.PlayerSteersEntityScriptEvent;
import com.denizenscript.denizen.events.player.ResourcePackStatusScriptEvent;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.nms.interfaces.packets.PacketInResourcePackStatus;
import com.denizenscript.denizen.nms.interfaces.packets.PacketInSteerVehicle;
import com.denizenscript.denizen.nms.interfaces.packets.PacketOutChat;
import com.denizenscript.denizen.nms.interfaces.packets.PacketOutEntityMetadata;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.commands.player.GlowCommand;
import com.denizenscript.denizen.scripts.commands.server.ExecuteCommand;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.objects.core.ElementTag;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class DenizenPacketHandler {
    public static DenizenPacketHandler instance;
    public static HashSet<UUID> forceNoclip;
    public static HashSet<Material> raisableItems;

    public void receivePacket(Player player, PacketInResourcePackStatus resourcePackStatus) {
        if (!ResourcePackStatusScriptEvent.instance.enabled) {
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)Denizen.getInstance(), () -> {
            ResourcePackStatusScriptEvent event = ResourcePackStatusScriptEvent.instance;
            event.status = new ElementTag(resourcePackStatus.getStatus());
            event.player = PlayerTag.mirrorBukkitPlayer((OfflinePlayer)player);
            event.fire();
        });
    }

    public boolean receivePacket(Player player, PacketInSteerVehicle steerVehicle, Runnable allow) {
        if (PlayerSteersEntityScriptEvent.instance.enabled) {
            Runnable process = () -> {
                if (!player.isInsideVehicle()) {
                    return;
                }
                PlayerSteersEntityScriptEvent event = PlayerSteersEntityScriptEvent.instance;
                event.player = PlayerTag.mirrorBukkitPlayer((OfflinePlayer)player);
                event.entity = new EntityTag(player.getVehicle());
                event.sideways = new ElementTag(steerVehicle.getLeftwardInput());
                event.forward = new ElementTag(steerVehicle.getForwardInput());
                event.jump = new ElementTag(steerVehicle.getJumpInput());
                event.dismount = new ElementTag(steerVehicle.getDismountInput());
                event.cancelled = false;
                event.modifyCancellation = c -> {
                    event.cancelled = c;
                };
                event.fire();
                if (!event.cancelled) {
                    allow.run();
                }
            };
            if (Bukkit.isPrimaryThread()) {
                process.run();
            } else {
                Bukkit.getScheduler().runTask((Plugin)Denizen.getInstance(), process);
            }
        }
        return false;
    }

    public static boolean isHoldingRaisable(Player player) {
        return raisableItems.contains(player.getEquipment().getItemInMainHand().getType()) || raisableItems.contains(player.getEquipment().getItemInOffHand().getType());
    }

    public void receivePlacePacket(Player player) {
        if (!PlayerHoldsItemEvent.instance.enabled) {
            return;
        }
        if (DenizenPacketHandler.isHoldingRaisable(player)) {
            Bukkit.getScheduler().runTask((Plugin)Denizen.getInstance(), () -> PlayerHoldsItemEvent.signalDidRaise(player));
        }
    }

    public void receiveDigPacket(Player player) {
        if (!PlayerHoldsItemEvent.instance.enabled) {
            return;
        }
        if (DenizenPacketHandler.isHoldingRaisable(player)) {
            Bukkit.getScheduler().runTask((Plugin)Denizen.getInstance(), () -> PlayerHoldsItemEvent.signalDidLower(player));
        }
    }

    public boolean shouldInterceptChatPacket() {
        return !ExecuteCommand.silencedPlayers.isEmpty() || PlayerReceivesMessageScriptEvent.instance.loaded || PlayerReceivesActionbarScriptEvent.instance.loaded;
    }

    public boolean sendPacket(Player player, PacketOutChat chat) {
        PlayerReceivesMessageScriptEvent event;
        if (!chat.isActionbar() && ExecuteCommand.silencedPlayers.contains(player.getUniqueId())) {
            return true;
        }
        if (chat.getMessage() == null) {
            return false;
        }
        PlayerReceivesMessageScriptEvent playerReceivesMessageScriptEvent = event = chat.isActionbar() ? PlayerReceivesActionbarScriptEvent.instance : PlayerReceivesMessageScriptEvent.instance;
        if (event.loaded) {
            Callable<Boolean> eventCall = () -> {
                event.message = new ElementTag(chat.getMessage());
                event.rawJson = new ElementTag(chat.getRawJson());
                event.system = new ElementTag(chat.isSystem());
                event.player = PlayerTag.mirrorBukkitPlayer((OfflinePlayer)player);
                event.modifyMessage = chat::setMessage;
                event.modifyRawJson = chat::setRawJson;
                event.cancelled = false;
                event.modifyCancellation = c -> {
                    event.cancelled = c;
                };
                event.fire();
                return event.cancelled;
            };
            try {
                if (DenizenCore.implementation.isSafeThread()) {
                    return eventCall.call();
                }
                FutureTask<Boolean> futureTask = new FutureTask<Boolean>(eventCall);
                Bukkit.getScheduler().runTask((Plugin)Denizen.getInstance(), futureTask);
                return futureTask.get();
            }
            catch (Exception e) {
                Debug.echoError(e);
                return false;
            }
        }
        return false;
    }

    public boolean shouldInterceptMetadata() {
        return !GlowCommand.glowViewers.isEmpty();
    }

    public boolean sendPacket(Player player, PacketOutEntityMetadata entityMetadata) {
        HashSet<UUID> players = GlowCommand.glowViewers.get(entityMetadata.getEntityId());
        return players != null && entityMetadata.checkForGlow() && !players.contains(player.getUniqueId());
    }

    static {
        forceNoclip = new HashSet();
        raisableItems = new HashSet();
        raisableItems.add(Material.SHIELD);
        raisableItems.add(Material.CROSSBOW);
        raisableItems.add(Material.BOW);
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_17)) {
            raisableItems.add(Material.valueOf((String)"SPYGLASS"));
        }
    }
}

