/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.debugging;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.bukkit.Bukkit;

public class StatsRecord
extends Thread {
    public String content;

    public static void trigger() {
        StatsRecord recorder = new StatsRecord();
        recorder.gather();
        recorder.start();
    }

    public void gather() {
        String denizenVersion = Denizen.getInstance().coreImplementation.getImplementationVersion();
        String differentiator = CoreUtilities.hash_md5((Bukkit.getServer().getMotd() + Bukkit.getServer().getPort()).getBytes(StandardCharsets.UTF_8));
        String deprecations = String.join((CharSequence)"\n", Deprecations.firedRecently);
        Deprecations.firedRecently.clear();
        String mcVersion = Bukkit.getVersion();
        int firstDash = mcVersion.indexOf(45);
        int secondDash = firstDash == -1 ? -1 : mcVersion.indexOf(45, firstDash + 1);
        int mcPart = mcVersion.indexOf("(MC: ");
        int endPart = mcPart == -1 ? -1 : mcVersion.indexOf(")", mcPart);
        String platform = secondDash == -1 ? "" : mcVersion.substring(firstDash + 1, secondDash);
        mcVersion = endPart == -1 ? "" : mcVersion.substring(mcPart + "(MC: ".length(), endPart);
        this.content = "postid=pluginstats&plugin=Denizen&differentiator=" + differentiator + "&pl_plugin_version=" + URLEncoder.encode(denizenVersion) + "&pl_platform=" + URLEncoder.encode(platform) + "&pl_minecraft_version=" + URLEncoder.encode(mcVersion) + "&pl_player_count=" + Bukkit.getOnlinePlayers().size() + "&pl_script_count=" + ScriptRegistry.scriptContainers.size() + "&pl_deprecations=" + URLEncoder.encode(deprecations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BufferedReader in = null;
        try {
            URL url = new URL("https://stats.mcmonkey.org/Stats/Submit");
            HttpURLConnection uc = (HttpURLConnection)url.openConnection();
            uc.setDoInput(true);
            uc.setDoOutput(true);
            uc.setConnectTimeout(10000);
            uc.connect();
            uc.getOutputStream().write(this.content.getBytes(StandardCharsets.UTF_8));
            in = new BufferedReader(new InputStreamReader(uc.getInputStream()));
            String Result = in.readLine();
            in.close();
        }
        catch (Exception e) {
            if (CoreConfiguration.debugOverride) {
                Debug.echoError(e);
            }
        }
        finally {
            block14: {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception e) {
                    if (!CoreConfiguration.debugOverride) break block14;
                    Debug.echoError(e);
                }
            }
        }
    }
}

