/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.nms.interfaces.ItemHelper;
import com.denizenscript.denizen.nms.util.jnbt.StringTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.properties.item.ItemBook;
import com.denizenscript.denizen.objects.properties.item.ItemColor;
import com.denizenscript.denizen.objects.properties.item.ItemDurability;
import com.denizenscript.denizen.objects.properties.item.ItemFirework;
import com.denizenscript.denizen.objects.properties.item.ItemInventory;
import com.denizenscript.denizen.objects.properties.item.ItemLock;
import com.denizenscript.denizen.scripts.containers.core.BookScriptContainer;
import com.denizenscript.denizen.scripts.containers.core.ItemScriptContainer;
import com.denizenscript.denizen.scripts.containers.core.ItemScriptHelper;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.nbt.CustomNBT;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.flags.AbstractFlagTracker;
import com.denizenscript.denizencore.flags.FlaggableObject;
import com.denizenscript.denizencore.flags.MapTagFlagTracker;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemTag
implements ObjectTag,
Adjustable,
FlaggableObject {
    private ItemStack item;
    public ItemMeta metaCache;
    public AbstractFlagTracker flagTrackerCache;
    private String prefix = "Item";
    public static ObjectTagProcessor<ItemTag> tagProcessor = new ObjectTagProcessor();
    public static LinkedHashMap<String, ItemPropertyMatchHelper> matchHelperCache = new LinkedHashMap();
    public static int MAX_MATCH_HELPER_CACHE = 1024;

    public static ItemTag valueOf(String string, PlayerTag player, NPCTag npc) {
        return ItemTag.valueOf(string, new BukkitTagContext(player, npc, null));
    }

    public static ItemTag valueOf(String string, Debuggable debugMe) {
        return ItemTag.valueOf(string, new BukkitTagContext(null, null, null, debugMe == null || debugMe.shouldDebug(), null));
    }

    public static ItemTag valueOf(String string, boolean debugMe) {
        return ItemTag.valueOf(string, new BukkitTagContext(null, null, null, debugMe, null));
    }

    @Fetchable(value="i")
    public static ItemTag valueOf(String string, TagContext context) {
        block17: {
            ItemTag stack;
            block16: {
                if (string == null || string.equals("")) {
                    return null;
                }
                stack = null;
                if (ObjectFetcher.isObjectWithProperties(string)) {
                    return ObjectFetcher.getObjectFromWithProperties(ItemTag.class, string, context);
                }
                if (string.startsWith("i@")) {
                    string = string.substring("i@".length());
                }
                string = CoreUtilities.toLowerCase(string);
                try {
                    BookScriptContainer book;
                    if (ScriptRegistry.containsScript(string, ItemScriptContainer.class)) {
                        ItemScriptContainer isc = ScriptRegistry.getScriptContainerAs(string, ItemScriptContainer.class);
                        stack = isc.getItemFrom(context);
                        if (stack == null && (context == null || context.showErrors())) {
                            Debug.echoError("Item script '" + isc.getName() + "' returned a null item.");
                        }
                    } else if (ScriptRegistry.containsScript(string, BookScriptContainer.class) && (stack = (book = ScriptRegistry.getScriptContainerAs(string, BookScriptContainer.class)).getBookFrom(context)) == null && (context == null || context.showErrors())) {
                        Debug.echoError("Book script '" + book.getName() + "' returned a null item.");
                    }
                    if (stack != null) {
                        return stack;
                    }
                }
                catch (Exception ex) {
                    if (!CoreConfiguration.debugVerbose) break block16;
                    Debug.echoError(ex);
                }
            }
            try {
                MaterialTag mat = MaterialTag.valueOf(string, context);
                if (mat != null) {
                    stack = new ItemTag(mat.getMaterial());
                }
                if (stack != null) {
                    return stack;
                }
            }
            catch (Exception ex) {
                if (!string.equalsIgnoreCase("none") && (context == null || context.showErrors())) {
                    Debug.log("Does not match a valid item ID or material: " + string);
                }
                if (!CoreConfiguration.debugVerbose) break block17;
                Debug.echoError(ex);
            }
        }
        if (context == null || context.showErrors()) {
            Debug.log("valueOf ItemTag returning null: " + string);
        }
        return null;
    }

    public static boolean matches(String arg) {
        if (arg == null) {
            return false;
        }
        if (CoreUtilities.toLowerCase(arg).startsWith("i@")) {
            return true;
        }
        if (ScriptRegistry.containsScript(arg, ItemScriptContainer.class)) {
            return true;
        }
        if (ScriptRegistry.containsScript(arg, BookScriptContainer.class)) {
            return true;
        }
        return ItemTag.valueOf(arg, CoreUtilities.noDebugContext) != null;
    }

    public static ItemTag getItemFor(ObjectTag object, TagContext context) {
        return object instanceof ItemTag ? (ItemTag)object : ItemTag.valueOf(object.toString(), context);
    }

    @Override
    public ObjectTag duplicate() {
        return new ItemTag(this.item.clone());
    }

    public ItemTag(Material material) {
        this(new ItemStack(material));
    }

    public ItemTag(Material material, int qty) {
        this(new ItemStack(material, qty));
    }

    public ItemTag(MaterialTag material, int qty) {
        this.item = new ItemStack(material.getMaterial(), qty);
    }

    public ItemTag(ItemStack item) {
        this.item = item == null || item.getType() == Material.AIR ? new ItemStack(Material.AIR, 0) : item.clone();
    }

    @Override
    public AbstractFlagTracker getFlagTracker() {
        if (this.flagTrackerCache == null) {
            String value = CustomNBT.getCustomNBT(this.getItemStack(), "flags", "Denizen");
            if (value == null) {
                return new MapTagFlagTracker();
            }
            this.flagTrackerCache = new MapTagFlagTracker(value, CoreUtilities.noDebugContext);
        }
        return this.flagTrackerCache;
    }

    @Override
    public void reapplyTracker(AbstractFlagTracker tracker) {
        if (tracker instanceof MapTagFlagTracker && ((MapTagFlagTracker)tracker).map.map.isEmpty()) {
            this.setItemStack(CustomNBT.removeCustomNBT(this.getItemStack(), "flags", "Denizen"));
        } else {
            this.setItemStack(CustomNBT.addCustomNBT(this.getItemStack(), "flags", tracker.toString(), "Denizen"));
        }
        this.flagTrackerCache = tracker;
    }

    public ItemStack getItemStack() {
        return this.item;
    }

    public ItemMeta getItemMeta() {
        if (this.metaCache == null) {
            this.metaCache = this.item.getItemMeta();
        }
        return this.metaCache;
    }

    public void setItemMeta(ItemMeta meta) {
        this.metaCache = meta;
        this.item.setItemMeta(meta);
    }

    public void setItemStack(ItemStack item) {
        this.item = item;
        this.resetCache();
    }

    public void resetCache() {
        this.metaCache = null;
        this.flagTrackerCache = null;
    }

    public int comparesTo(ItemTag item) {
        return this.comparesTo(item.getItemStack());
    }

    public int comparesTo(ItemStack compared_to) {
        if (this.item == null) {
            return -1;
        }
        int determination = 0;
        ItemStack compared = this.getItemStack();
        if (compared.getType() != compared_to.getType()) {
            return -1;
        }
        if (compared_to.hasItemMeta()) {
            if (!compared.hasItemMeta()) {
                return -1;
            }
            ItemMeta thisMeta = this.getItemMeta();
            ItemMeta comparedItemMeta = compared_to.getItemMeta();
            if (comparedItemMeta.hasDisplayName()) {
                if (!thisMeta.hasDisplayName()) {
                    return -1;
                }
                if (CoreUtilities.toLowerCase(comparedItemMeta.getDisplayName()).startsWith(CoreUtilities.toLowerCase(thisMeta.getDisplayName()))) {
                    if (thisMeta.getDisplayName().length() > comparedItemMeta.getDisplayName().length()) {
                        ++determination;
                    }
                } else {
                    return -1;
                }
            }
            if (comparedItemMeta.hasLore()) {
                if (!thisMeta.hasLore()) {
                    return -1;
                }
                for (String string : comparedItemMeta.getLore()) {
                    if (thisMeta.getLore().contains(string)) continue;
                    return -1;
                }
                if (thisMeta.getLore().size() > comparedItemMeta.getLore().size()) {
                    ++determination;
                }
            }
            if (!comparedItemMeta.getEnchants().isEmpty()) {
                if (thisMeta.getEnchants().isEmpty()) {
                    return -1;
                }
                for (Map.Entry entry : comparedItemMeta.getEnchants().entrySet()) {
                    if (thisMeta.getEnchants().containsKey(entry.getKey()) && (Integer)thisMeta.getEnchants().get(entry.getKey()) >= (Integer)entry.getValue()) continue;
                    return -1;
                }
                if (thisMeta.getEnchants().size() > comparedItemMeta.getEnchants().size()) {
                    ++determination;
                }
            }
            if (this.isRepairable() && ((Damageable)thisMeta).getDamage() < ((Damageable)comparedItemMeta).getDamage()) {
                ++determination;
            }
        }
        return determination;
    }

    public boolean isItemscript() {
        return ItemScriptHelper.isItemscript(this.item);
    }

    public String getScriptName() {
        return ItemScriptHelper.getItemScriptNameText(this.item);
    }

    public void setItemScriptName(String name) {
        this.setItemStack(NMSHandler.itemHelper.addNbtData(this.getItemStack(), "DenizenItemScript", new StringTag(CoreUtilities.toLowerCase(name))));
    }

    public void setItemScript(ItemScriptContainer script) {
        if (script.contains("NO_ID", String.class) && Boolean.parseBoolean(script.getString("NO_ID"))) {
            return;
        }
        this.setItemScriptName(script.getName());
    }

    public Material getBukkitMaterial() {
        return this.getItemStack().getType();
    }

    public MaterialTag getMaterial() {
        return new MaterialTag(this.getBukkitMaterial());
    }

    public void setAmount(int value) {
        if (this.item != null) {
            this.item.setAmount(value);
        }
    }

    public int getAmount() {
        if (this.item != null) {
            return this.item.getAmount();
        }
        return 0;
    }

    public void setDurability(short value) {
        ItemMeta meta = this.getItemMeta();
        if (meta instanceof Damageable) {
            ((Damageable)meta).setDamage((int)value);
            this.setItemMeta(meta);
        }
    }

    public boolean isRepairable() {
        return this.getItemMeta() instanceof Damageable;
    }

    public boolean matchesRawExact(ItemTag item) {
        ItemTag thisItem = this;
        if (thisItem.getItemStack().getAmount() != 1) {
            thisItem = new ItemTag(thisItem.getItemStack().clone());
            thisItem.getItemStack().setAmount(1);
        }
        if (item.getItemStack().getAmount() != 1) {
            item = new ItemTag(item.getItemStack().clone());
            item.getItemStack().setAmount(1);
        }
        return thisItem.identify().equals(item.identify());
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public ItemTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String identify() {
        if (this.item == null || this.item.getType() == Material.AIR) {
            return "i@air";
        }
        return "i@" + this.getMaterial().identifyNoPropertiesNoIdentifier() + PropertyParser.getPropertiesString(this);
    }

    @Override
    public String debuggable() {
        if (this.item == null || this.item.getType() == Material.AIR) {
            return "<LG>i@<Y>air";
        }
        return "<LG>i@<Y>" + this.getMaterial().identifyNoPropertiesNoIdentifier() + PropertyParser.getPropertiesDebuggable(this);
    }

    @Override
    public String identifySimple() {
        if (this.item == null) {
            return "null";
        }
        if (this.item.getType() != Material.AIR && this.isItemscript()) {
            return "i@" + this.getScriptName();
        }
        return "i@" + this.identifyMaterial().replace("m@", "");
    }

    public String identifyMaterial() {
        return this.getMaterial().identifySimple();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public Object getJavaObject() {
        return this.getItemStack();
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public boolean isTruthy() {
        return !this.getBukkitMaterial().isAir();
    }

    public static void register() {
        AbstractFlagTracker.registerFlagHandlers(tagProcessor);
        PropertyParser.registerPropertyTagHandlers(ItemTag.class, tagProcessor);
        tagProcessor.registerTag(ElementTag.class, "repairable", (attribute, object) -> new ElementTag(ItemDurability.describes(object)), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_book", (attribute, object) -> new ElementTag(ItemBook.describes(object)), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_colorable", (attribute, object) -> new ElementTag(ItemColor.describes(object)), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_dyeable", (attribute, object) -> new ElementTag(ItemColor.describes(object)), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_firework", (attribute, object) -> new ElementTag(ItemFirework.describes(object)), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "has_inventory", (attribute, object) -> new ElementTag(ItemInventory.describes(object)), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_lockable", (attribute, object) -> new ElementTag(ItemLock.describes(object)), new String[0]);
        tagProcessor.registerTag(ObjectTag.class, "material", (attribute, object) -> {
            if (attribute.getAttribute(2).equals("formatted")) {
                return object;
            }
            if (object.getItemMeta() instanceof BlockStateMeta) {
                if (object.getBukkitMaterial() == Material.SHIELD) {
                    MaterialTag material = new MaterialTag(Material.SHIELD);
                    material.setModernData(((BlockStateMeta)object.getItemMeta()).getBlockState().getBlockData());
                    return material;
                }
                return new MaterialTag(((BlockStateMeta)object.getItemMeta()).getBlockState());
            }
            return object.getMaterial();
        }, new String[0]);
        tagProcessor.registerTag(ObjectTag.class, "placed_material", (attribute, object) -> {
            BlockData data = NMSHandler.itemHelper.getPlacedBlock(object.getBukkitMaterial());
            if (data == null) {
                return null;
            }
            return new MaterialTag(data);
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "json", (attribute, object) -> new ElementTag(NMSHandler.itemHelper.getJsonString(object.item)), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "meta_type", (attribute, object) -> new ElementTag(object.getItemMeta().getClass().getName()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "bukkit_serial", (attribute, object) -> {
            YamlConfiguration config = new YamlConfiguration();
            config.set("item", (Object)object.getItemStack());
            return new ElementTag(config.saveToString());
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "simple", (attribute, object) -> new ElementTag(object.identifySimple()), new String[0]);
        tagProcessor.registerTag(ListTag.class, "recipe_ids", (attribute, object) -> {
            String type = attribute.hasParam() ? CoreUtilities.toLowerCase(attribute.getParam()) : null;
            ItemScriptContainer container = ItemScriptHelper.getItemScriptContainer(object.getItemStack());
            ListTag list = new ListTag();
            Consumer<NamespacedKey> addRecipe = recipe -> {
                if (CoreUtilities.equalsIgnoreCase(recipe.getNamespace(), "denizen") ? container != ItemScriptHelper.recipeIdToItemScript.get(recipe.toString()) : container != null) {
                    return;
                }
                list.add(recipe.toString());
            };
            if (type == null || !type.equals("brewing")) {
                for (Recipe recipe2 : Bukkit.getRecipesFor((ItemStack)object.getItemStack())) {
                    if (!(recipe2 instanceof Keyed)) continue;
                    Keyed keyedRecipe = (Keyed)recipe2;
                    if (!Utilities.isRecipeOfType(recipe2, type)) continue;
                    addRecipe.accept(keyedRecipe.getKey());
                }
            }
            if (Denizen.supportsPaper && NMSHandler.getVersion().isAtLeast(NMSVersion.v1_18) && (type == null || type.equals("brewing"))) {
                for (Map.Entry entry : NMSHandler.itemHelper.getCustomBrewingRecipes().entrySet()) {
                    ItemStack result = ((ItemHelper.BrewingRecipe)entry.getValue()).result();
                    if (object.getBukkitMaterial() != result.getType() || object.getItemStack().getDurability() != -1 && object.getItemStack().getDurability() != result.getDurability()) continue;
                    addRecipe.accept((NamespacedKey)entry.getKey());
                }
            }
            return list;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "formatted", (attribute, object) -> new ElementTag(object.formattedName()), new String[0]);
        tagProcessor.registerMechanism("material", true, MaterialTag.class, (object, mechanism, material) -> object.item.setType(material.getMaterial()), new String[0]);
    }

    public String formattedName() {
        String id = CoreUtilities.toLowerCase(this.getMaterial().name()).replace('_', ' ');
        if (id.equals("air")) {
            return "nothing";
        }
        if (id.equals("ice") || id.equals("dirt") || id.endsWith("copper") || id.endsWith("cream")) {
            return id;
        }
        if (this.getItemStack().getAmount() > 1) {
            if (id.equals("cactus")) {
                return "cacti";
            }
            if (id.endsWith(" off")) {
                id = id.substring(0, id.length() - 4);
            }
            if (id.endsWith(" on")) {
                id = id.substring(0, id.length() - 3);
            }
            if (id.equals("rotten flesh") || id.equals("cooked fish") || id.equals("raw fish") || id.endsWith("s")) {
                return id;
            }
            if (id.endsWith("y")) {
                return id.substring(0, id.length() - 1) + "ies";
            }
            if (id.endsWith("sh") || id.endsWith("ch")) {
                return id + "es";
            }
            return id + "s";
        }
        if (id.equals("cactus")) {
            return "a cactus";
        }
        if (id.endsWith("s")) {
            return id;
        }
        if (id.endsWith(" off")) {
            return "a " + id.substring(0, id.length() - 4);
        }
        if (id.endsWith(" on")) {
            return "a " + id.substring(0, id.length() - 3);
        }
        if (id.startsWith("a") || id.startsWith("e") || id.startsWith("i") || id.startsWith("o") || id.startsWith("u")) {
            return "an " + id;
        }
        return "a " + id;
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        this.adjust(mechanism);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        tagProcessor.processMechanism(this, mechanism);
    }

    public static ItemPropertyMatchHelper getPropertyMatchHelper(String text) {
        ItemPropertyMatchHelper matchHelper;
        if (CoreConfiguration.debugVerbose) {
            Debug.verboseLog("[ItemPropertyMatchHelper] getting helper for " + text);
        }
        if ((matchHelper = matchHelperCache.get(text)) != null) {
            return matchHelper;
        }
        ItemTag item = ItemTag.valueOf(text, CoreUtilities.noDebugContext);
        if (item == null) {
            Debug.verboseLog("[ItemPropertyMatchHelper] rejecting item because it's null");
            return null;
        }
        matchHelper = new ItemPropertyMatchHelper();
        matchHelper.properItem = item;
        List<String> propertiesGiven = ObjectFetcher.separateProperties(text);
        if (propertiesGiven == null) {
            return matchHelper;
        }
        PropertyParser.ClassPropertiesInfo itemInfo = PropertyParser.propertiesByClass.get(ItemTag.class);
        for (int i = 1; i < propertiesGiven.size(); ++i) {
            Property realProp;
            String property = propertiesGiven.get(i);
            int equalSign = property.indexOf(61);
            if (equalSign == -1) {
                if (CoreConfiguration.debugVerbose) {
                    Debug.verboseLog("[ItemPropertyMatchHelper] rejecting item because " + property + " lacks an equal sign");
                }
                return null;
            }
            String label = ObjectFetcher.unescapeProperty(property.substring(0, equalSign));
            PropertyParser.PropertyGetter getter = itemInfo.propertiesByMechanism.get(label);
            if (getter == null || (realProp = getter.get(item)) == null) continue;
            matchHelper.comparisons.add(new ItemPropertyMatchHelper.PropertyComparison(realProp.getPropertyString(), getter));
        }
        if (matchHelperCache.size() > MAX_MATCH_HELPER_CACHE) {
            String firstMost = matchHelperCache.keySet().iterator().next();
            matchHelperCache.remove(firstMost);
        }
        if (CoreConfiguration.debugVerbose) {
            Debug.verboseLog("[ItemPropertyMatchHelper] stored final result as " + matchHelper);
        }
        matchHelperCache.put(text, matchHelper);
        return matchHelper;
    }

    @Override
    public boolean advancedMatches(String matcher) {
        ScriptEvent.MatchHelper matchHelper;
        String matcherLow = CoreUtilities.toLowerCase(matcher);
        if (matcherLow.contains(":")) {
            if (matcherLow.startsWith("item_flagged:")) {
                if (this.getBukkitMaterial().isAir()) {
                    return false;
                }
                return BukkitScriptEvent.coreFlaggedCheck(matcher.substring("item_flagged:".length()), this.getFlagTracker());
            }
            if (matcherLow.startsWith("item_enchanted:")) {
                String enchMatcher = matcher.substring("item_enchanted:".length());
                if (this.getBukkitMaterial().isAir() || !this.getItemMeta().hasEnchants()) {
                    return false;
                }
                for (Enchantment enchant : this.getItemMeta().getEnchants().keySet()) {
                    if (!BukkitScriptEvent.runGenericCheck(enchMatcher, enchant.getKey().getKey())) continue;
                    return true;
                }
                return false;
            }
            if (matcherLow.startsWith("raw_exact:")) {
                ItemTag compareItem = ItemTag.valueOf(matcher.substring("raw_exact:".length()), CoreUtilities.errorButNoDebugContext);
                return compareItem != null && compareItem.matchesRawExact(this);
            }
        }
        if (matcherLow.equals("potion") && CoreUtilities.toLowerCase(this.getBukkitMaterial().name()).contains("potion")) {
            return true;
        }
        boolean isItemScript = this.isItemscript();
        if (matcherLow.equals("script") && isItemScript) {
            return true;
        }
        if (matcher.contains("[") && matcher.endsWith("]")) {
            ItemPropertyMatchHelper helper = ItemTag.getPropertyMatchHelper(matcher);
            if (helper == null) {
                return false;
            }
            return helper.doesMatch(this);
        }
        if (isItemScript && (matchHelper = BukkitScriptEvent.createMatcher(matcher)).doesMatch(this.getScriptName())) {
            return true;
        }
        return MaterialTag.advancedMatchesInternal(this.getBukkitMaterial(), matcher, !isItemScript);
    }

    public static class ItemPropertyMatchHelper {
        public ItemTag properItem;
        public List<PropertyComparison> comparisons = new ArrayList<PropertyComparison>();

        public final boolean doesMatch(ItemTag item) {
            if (item == null) {
                return false;
            }
            if (item.getBukkitMaterial() != this.properItem.getBukkitMaterial()) {
                Debug.verboseLog("[ItemPropertyMatchHelper] deny because material mismatch");
                return false;
            }
            for (PropertyComparison comparison : this.comparisons) {
                Property p = comparison.getter.get(item);
                if (p == null) {
                    Debug.verboseLog("[ItemPropertyMatchHelper] deny because property is null");
                    return false;
                }
                String val = p.getPropertyString();
                if (comparison.compareValue == null) {
                    if (val == null) continue;
                    Debug.verboseLog("[ItemPropertyMatchHelper] deny because nullity");
                    return false;
                }
                if (val != null && CoreUtilities.equalsIgnoreCase(comparison.compareValue, val)) continue;
                Debug.verboseLog("[ItemPropertyMatchHelper] deny because unequal");
                return false;
            }
            return true;
        }

        public String toString() {
            return "item=" + this.properItem + ", comparisons=" + this.comparisons.stream().map(c -> c.compareValue).collect(Collectors.joining(", "));
        }

        public static class PropertyComparison {
            public String compareValue;
            public PropertyParser.PropertyGetter getter;

            public PropertyComparison(String compareValue, PropertyParser.PropertyGetter getter) {
                this.compareValue = compareValue;
                this.getter = getter;
            }
        }
    }
}

