/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Entity;
import org.bukkit.entity.PigZombie;

public class EntityAnger
implements Property {
    public static final String[] handledMechs = new String[]{"anger"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        if (!(entity instanceof EntityTag)) {
            return false;
        }
        Entity bukkitEntity = ((EntityTag)entity).getBukkitEntity();
        return bukkitEntity instanceof PigZombie || bukkitEntity instanceof Bee;
    }

    public static EntityAnger getFrom(ObjectTag entity) {
        if (!EntityAnger.describes(entity)) {
            return null;
        }
        return new EntityAnger((EntityTag)entity);
    }

    public EntityAnger(EntityTag entity) {
        this.entity = entity;
    }

    @Override
    public String getPropertyString() {
        return new DurationTag((long)this.getAnger()).identify();
    }

    @Override
    public String getPropertyId() {
        return "anger";
    }

    public int getAnger() {
        if (this.isPigZombie()) {
            return this.getPigZombie().getAnger();
        }
        return this.getBee().getAnger();
    }

    public boolean isPigZombie() {
        return this.entity.getBukkitEntity() instanceof PigZombie;
    }

    public PigZombie getPigZombie() {
        return (PigZombie)this.entity.getBukkitEntity();
    }

    public Bee getBee() {
        return (Bee)this.entity.getBukkitEntity();
    }

    public static void register() {
        PropertyParser.registerTag(EntityAnger.class, DurationTag.class, "anger", (attribute, object) -> new DurationTag((long)object.getAnger()), new String[0]);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("anger") && mechanism.requireObject(DurationTag.class)) {
            DurationTag duration = mechanism.getValue().isInt() ? new DurationTag(mechanism.getValue().asLong()) : mechanism.valueAsType(DurationTag.class);
            if (this.isPigZombie()) {
                this.getPigZombie().setAnger(duration.getTicksAsInt());
            } else {
                this.getBee().setAnger(duration.getTicksAsInt());
            }
        }
    }
}

