/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_17.helpers;

import com.denizenscript.denizen.nms.interfaces.BlockHelper;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTagBuilder;
import com.denizenscript.denizen.nms.v1_17.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_17.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockBell;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyInstrument;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.material.EnumPistonReaction;
import org.bukkit.Color;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.block.data.type.Bell;
import org.bukkit.craftbukkit.v1_17_R1.CraftChunk;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_17_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_17_R1.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_17_R1.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_17_R1.block.CraftSkull;
import org.bukkit.craftbukkit.v1_17_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_17_R1.util.CraftMagicNumbers;
import org.bukkit.inventory.ItemStack;

public class BlockHelperImpl
implements BlockHelper {
    public static final Field craftBlockEntityState_tileEntity = ReflectionHelper.getFields(CraftBlockEntityState.class).get((Object)"tileEntity");
    public static final Field craftBlockEntityState_snapshot = ReflectionHelper.getFields(CraftBlockEntityState.class).get((Object)"snapshot");
    public static final Field craftSkull_profile = ReflectionHelper.getFields(CraftSkull.class).get((Object)"profile");
    public static final MethodHandle CRAFTBLOCKSTATE_CONSTRUCTOR = ReflectionHelper.getConstructor(CraftBlockState.class, (Class[])new Class[]{Block.class});
    public static final Field BLOCK_MATERIAL = ReflectionHelper.getFields(BlockBase.class).getFirstOfType(dew.class);
    public static final MethodHandle MATERIAL_PUSH_REACTION_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(dew.class, EnumPistonReaction.class);
    public static final MethodHandle BLOCK_STRENGTH_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(BlockBase.BlockData.class, Float.TYPE);
    public static MethodHandle BLOCKSTATEBASE_GETFLUIDSTATE = ReflectionHelper.getMethodHandle(BlockBase.BlockData.class, (String)"getFluid", (Class[])new Class[0]);
    public static MethodHandle FLUIDSTATE_ISRANDOMLYTICKING = ReflectionHelper.getMethodHandle((Class)BLOCKSTATEBASE_GETFLUIDSTATE.type().returnType(), (String)"f", (Class[])new Class[0]);
    public static MethodHandle FLUIDSTATE_ISEMPTY = ReflectionHelper.getMethodHandle((Class)BLOCKSTATEBASE_GETFLUIDSTATE.type().returnType(), (String)"isEmpty", (Class[])new Class[0]);
    public static MethodHandle FLUIDSTATE_CREATELEGACYBLOCK = ReflectionHelper.getMethodHandle((Class)BLOCKSTATEBASE_GETFLUIDSTATE.type().returnType(), (String)"getBlockData", (Class[])new Class[0]);
    public static MethodHandle FLUIDSTATE_ANIMATETICK = ReflectionHelper.getMethodHandle((Class)BLOCKSTATEBASE_GETFLUIDSTATE.type().returnType(), (String)"a", (Class[])new Class[]{World.class, BlockPosition.class, Random.class});

    public void makeBlockStateRaw(BlockState state) {
        try {
            craftBlockEntityState_snapshot.set(state, craftBlockEntityState_tileEntity.get(state));
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void applyPhysics(Location location) {
        BlockPosition pos = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        ((CraftWorld)location.getWorld()).getHandle().applyPhysics(pos, CraftMagicNumbers.getBlock((Material)location.getBlock().getType()));
    }

    public static <T extends TileEntity> T getTE(CraftBlockEntityState<T> cbs) {
        try {
            return (T)((TileEntity)craftBlockEntityState_tileEntity.get(cbs));
        }
        catch (IllegalAccessException e) {
            Debug.echoError((Throwable)e);
            return null;
        }
    }

    public PlayerProfile getPlayerProfile(Skull skull) {
        GameProfile profile = ((TileEntitySkull)BlockHelperImpl.getTE((CraftSkull)skull)).e;
        if (profile == null) {
            return null;
        }
        String name = profile.getName();
        UUID id = profile.getId();
        Property property = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
        return new PlayerProfile(name, id, property != null ? property.getValue() : null);
    }

    public void setPlayerProfile(Skull skull, PlayerProfile playerProfile) {
        GameProfile gameProfile = new GameProfile(playerProfile.getUniqueId(), playerProfile.getName());
        if (playerProfile.hasTexture()) {
            gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture(), playerProfile.getTextureSignature()));
        }
        try {
            craftSkull_profile.set(skull, gameProfile);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
        skull.update();
    }

    public CompoundTag getNbtData(Block block) {
        TileEntity te = ((CraftWorld)block.getWorld()).getHandle().getTileEntity(new BlockPosition(block.getX(), block.getY(), block.getZ()), true);
        if (te != null) {
            NBTTagCompound compound = new NBTTagCompound();
            te.save(compound);
            return CompoundTagImpl.fromNMSTag(compound);
        }
        return null;
    }

    public void setNbtData(Block block, CompoundTag ctag) {
        CompoundTagBuilder builder = ctag.createBuilder();
        builder.putInt("x", block.getX());
        builder.putInt("y", block.getY());
        builder.putInt("z", block.getZ());
        ctag = builder.build();
        BlockPosition blockPos = new BlockPosition(block.getX(), block.getY(), block.getZ());
        TileEntity te = ((CraftWorld)block.getWorld()).getHandle().getTileEntity(blockPos, true);
        te.load(((CompoundTagImpl)ctag).toNMSTag());
    }

    public boolean setBlockResistance(Material material, float resistance) {
        bzp block = this.getMaterialBlock(material);
        if (block == null) {
            return false;
        }
        ReflectionHelper.setFieldValue(BlockBase.class, (String)ReflectionMappingsInfo.BlockBehaviour_explosionResistance, (Object)block, (Object)Float.valueOf(resistance));
        return true;
    }

    public float getBlockResistance(Material material) {
        bzp block = this.getMaterialBlock(material);
        if (block == null) {
            return 0.0f;
        }
        return ((Float)ReflectionHelper.getFieldValue(BlockBase.class, (String)ReflectionMappingsInfo.BlockBehaviour_explosionResistance, (Object)block)).floatValue();
    }

    public BlockState generateBlockState(Block block, Material mat) {
        try {
            CraftBlockState state = CRAFTBLOCKSTATE_CONSTRUCTOR.invoke(block);
            state.setData(CraftMagicNumbers.getBlock((Material)mat).getBlockData());
            return state;
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
            return null;
        }
    }

    public bzp getMaterialBlock(Material bukkitMaterial) {
        if (!bukkitMaterial.isBlock()) {
            return null;
        }
        return ((CraftBlockData)bukkitMaterial.createBlockData()).getState().getBlock();
    }

    public dew getInternalMaterial(Material bukkitMaterial) {
        try {
            return (dew)BLOCK_MATERIAL.get(this.getMaterialBlock(bukkitMaterial));
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
            return null;
        }
    }

    public String getPushReaction(Material mat) {
        return this.getInternalMaterial(mat).getPushReaction().name();
    }

    public void setPushReaction(Material mat, String reaction) {
        try {
            MATERIAL_PUSH_REACTION_SETTER.invoke(this.getInternalMaterial(mat), EnumPistonReaction.valueOf((String)reaction));
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public float getBlockStrength(Material mat) {
        return this.getMaterialBlock((Material)mat).getBlockData().k;
    }

    public void setBlockStrength(Material mat, float strength) {
        try {
            BLOCK_STRENGTH_SETTER.invoke(this.getMaterialBlock(mat).getBlockData(), strength);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void doRandomTick(Location location) {
        BlockPosition pos = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        Chunk nmsChunk = ((CraftChunk)location.getChunk()).getHandle();
        IBlockData nmsBlock = nmsChunk.getType(pos);
        WorldServer nmsWorld = ((CraftWorld)location.getWorld()).getHandle();
        if (nmsBlock.isTicking()) {
            nmsBlock.b(nmsWorld, pos, nmsWorld.w);
        }
        try {
            Object fluid = BLOCKSTATEBASE_GETFLUIDSTATE.invoke(nmsBlock);
            if (FLUIDSTATE_ISRANDOMLYTICKING.invoke(fluid)) {
                FLUIDSTATE_ANIMATETICK.invoke(fluid, nmsWorld, pos, nmsWorld.w);
            }
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public Instrument getInstrumentFor(Material mat) {
        bzp blockType = this.getMaterialBlock(mat);
        BlockPropertyInstrument nmsInstrument = BlockPropertyInstrument.a((IBlockData)blockType.getBlockData());
        return Instrument.values()[nmsInstrument.ordinal()];
    }

    public void ringBell(org.bukkit.block.Bell block) {
        Bell bellData = (Bell)block.getBlockData();
        EnumDirection face = EnumDirection.a((String)bellData.getFacing().name());
        EnumDirection dir = EnumDirection.c;
        switch (bellData.getAttachment()) {
            case DOUBLE_WALL: 
            case SINGLE_WALL: {
                switch (face) {
                    case c: 
                    case d: {
                        dir = EnumDirection.f;
                    }
                }
                break;
            }
            case FLOOR: {
                dir = face;
            }
        }
        CraftBlock craftBlock = (CraftBlock)block.getBlock();
        ((BlockBell)bzq.mp).a((World)craftBlock.getCraftWorld().getHandle(), craftBlock.getPosition(), dir);
    }

    public int getExpDrop(Block block, ItemStack item) {
        bzp blockType = this.getMaterialBlock(block.getType());
        if (blockType == null) {
            return 0;
        }
        return blockType.getExpDrop(((CraftBlock)block).getNMS(), ((CraftBlock)block).getCraftWorld().getHandle(), ((CraftBlock)block).getPosition(), item == null ? null : CraftItemStack.asNMSCopy((ItemStack)item));
    }

    public Color getMapColor(Block block) {
        CraftBlock craftBlock = (CraftBlock)block;
        return Color.fromRGB((int)craftBlock.getNMS().d((IBlockAccess)craftBlock.getHandle(), (BlockPosition)craftBlock.getPosition()).al);
    }
}

