/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_18.impl;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.BiomeNMS;
import com.denizenscript.denizen.nms.v1_18.ReflectionMappingsInfo;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_18_R2.CraftWorld;
import org.bukkit.entity.EntityType;

public class BiomeNMSImpl
extends BiomeNMS {
    public gs<cbr> biomeBase;
    public adw world;

    public BiomeNMSImpl(adw world, String name) {
        super((World)world.getWorld(), name);
        this.world = world;
        this.biomeBase = world.s().d(hb.aP).b(ys.a((ys)hb.aP, (yt)new yt(name))).orElse(null);
    }

    public BiomeNMS.DownfallType getDownfallType() {
        cbr.d nmsType = ((cbr)this.biomeBase.a()).c();
        return switch (nmsType) {
            case cbr.d.b -> BiomeNMS.DownfallType.RAIN;
            case cbr.d.c -> BiomeNMS.DownfallType.SNOW;
            case cbr.d.a -> BiomeNMS.DownfallType.NONE;
            default -> throw new UnsupportedOperationException();
        };
    }

    public float getHumidity() {
        return ((cbr)this.biomeBase.a()).h();
    }

    public float getBaseTemperature() {
        return ((cbr)this.biomeBase.a()).i();
    }

    public List<EntityType> getAmbientEntities() {
        return this.getSpawnableEntities(ayb.c);
    }

    public List<EntityType> getCreatureEntities() {
        return this.getSpawnableEntities(ayb.b);
    }

    public List<EntityType> getMonsterEntities() {
        return this.getSpawnableEntities(ayb.a);
    }

    public List<EntityType> getWaterEntities() {
        return this.getSpawnableEntities(ayb.f);
    }

    public int getFoliageColor() {
        if (((cbr)this.biomeBase.a()).g() != 0) {
            return ((cbr)this.biomeBase.a()).g();
        }
        float temperature = this.clampColor(this.getBaseTemperature());
        float humidity = this.clampColor(this.getHumidity());
        int temperatureValue = (int)((1.0f - temperature) * 255.0f);
        int humidityValue = (int)((1.0f - (humidity *= temperature)) * 255.0f);
        int index = temperatureValue << 8 | humidityValue;
        return index >= 65536 ? 4764952 : this.getColor(index / 256, index % 256).asRGB();
    }

    public Object getClimate() {
        return ReflectionHelper.getFieldValue(cbr.class, (String)ReflectionMappingsInfo.Biome_climateSettings, (Object)this.biomeBase.a());
    }

    public void setHumidity(float humidity) {
        Object climate = this.getClimate();
        ReflectionHelper.setFieldValue(climate.getClass(), (String)ReflectionMappingsInfo.Biome_ClimateSettings_downfall, (Object)climate, (Object)Float.valueOf(humidity));
    }

    public void setBaseTemperature(float temperature) {
        Object climate = this.getClimate();
        ReflectionHelper.setFieldValue(climate.getClass(), (String)ReflectionMappingsInfo.Biome_ClimateSettings_temperature, (Object)climate, (Object)Float.valueOf(temperature));
    }

    public void setPrecipitation(BiomeNMS.DownfallType type) {
        cbr.d nmsType = switch (type) {
            case BiomeNMS.DownfallType.RAIN -> cbr.d.b;
            case BiomeNMS.DownfallType.SNOW -> cbr.d.c;
            case BiomeNMS.DownfallType.NONE -> cbr.d.a;
            default -> throw new UnsupportedOperationException();
        };
        Object climate = this.getClimate();
        ReflectionHelper.setFieldValue(climate.getClass(), (String)ReflectionMappingsInfo.Biome_ClimateSettings_precipitation, (Object)climate, (Object)nmsType);
    }

    public void setFoliageColor(int color) {
        try {
            ReflectionHelper.setFieldValue(cbw.class, (String)ReflectionMappingsInfo.BiomeSpecialEffects_foliageColorOverride, (Object)((cbr)this.biomeBase.a()).j(), Optional.of(color));
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    private List<EntityType> getSpawnableEntities(ayb creatureType) {
        ccb mobs = ((cbr)this.biomeBase.a()).b();
        auw typeSettingList = mobs.a(creatureType);
        ArrayList<EntityType> entityTypes = new ArrayList<EntityType>();
        if (typeSettingList == null) {
            return entityTypes;
        }
        for (ccb.c meta : typeSettingList.e()) {
            try {
                String n = axo.a((axo)meta.b).a();
                EntityType et = EntityType.fromName((String)n);
                if (et == null) {
                    et = EntityType.valueOf((String)n.toUpperCase(Locale.ENGLISH));
                }
                entityTypes.add(et);
            }
            catch (Throwable throwable) {}
        }
        return entityTypes;
    }

    public void setTo(Block block) {
        cra chunk;
        if (((CraftWorld)block.getWorld()).getHandle() != this.world) {
            NMSHandler.instance.getBiomeNMS(block.getWorld(), this.getName()).setTo(block);
            return;
        }
        gj pos = new gj(block.getX(), 0, block.getZ());
        if (this.world.C(pos) && (chunk = this.world.l(pos)) != null) {
            chunk.setBiome(block.getX() >> 2, block.getY() >> 2, block.getZ() >> 2, this.biomeBase);
            chunk.a(true);
        }
    }
}

