/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.notables;

import java.util.List;
import net.citizensnpcs.api.CitizensAPI;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.bukkit.Location;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Notable {
    private final String name;
    private final Location location;
    private List<Integer> links;

    public Notable(String name, Location location) {
        this.location = location;
        this.name = name.toUpperCase();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        Notable onote = (Notable)object;
        return new EqualsBuilder().append((Object)this.name, (Object)onote.getName()).isEquals();
    }

    public boolean addLink(Integer npcid) {
        if (this.links.contains(npcid)) {
            return false;
        }
        this.links.add(npcid);
        return true;
    }

    public boolean hasLink(Integer npcid) {
        return this.links.contains(npcid);
    }

    public boolean removeLink(Integer npcid) {
        if (!this.links.contains(npcid)) {
            return false;
        }
        this.links.remove(npcid);
        return true;
    }

    public List<Integer> getLinks() {
        return this.links;
    }

    public String getName() {
        return this.name;
    }

    public Location getLocation() {
        return this.location;
    }

    public int hashCode() {
        return new HashCodeBuilder(13, 21).append((Object)this.name).toHashCode();
    }

    public String stringValue() {
        String linkString = "";
        for (Integer npcid : this.links) {
            linkString = ";" + npcid;
        }
        return this.name + ";" + this.location.getWorld().getName() + ";" + this.location.getX() + ";" + this.location.getY() + ";" + this.location.getZ() + linkString;
    }

    public String toString() {
        String linkString = " Links: ";
        for (Integer npcid : this.links) {
            linkString = CitizensAPI.getNPCRegistry().getById(npcid.intValue()) + "/" + npcid + ", ";
        }
        linkString = this.links.size() > 0 ? " Links: none" : linkString.substring(0, linkString.length() - 2);
        return "Name: " + this.name + " World: " + this.location.getWorld().getName() + " Location: " + this.location.getBlockX() + "," + this.location.getBlockY() + "," + this.location.getBlockZ() + linkString;
    }

    public String describe() {
        return "<a>" + this.name + "<b> " + this.location.getWorld().getName() + "<c> " + this.location.getBlockX() + "," + this.location.getBlockY() + "," + this.location.getBlockZ();
    }
}

