/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.notables;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.notables.Notable;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.Location;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotableManager {
    Denizen denizen;
    private List<Notable> notables = new ArrayList<Notable>();
    private Map<Integer, List<String>> links = new ConcurrentHashMap<Integer, List<String>>();

    public NotableManager(Denizen denizen) {
        this.denizen = denizen;
    }

    public boolean addLink(String notableName, NPC npc) {
        Notable notable = this.getNotable(notableName);
        if (notable == null) {
            return false;
        }
        this.getNotable(notableName).addLink(npc.getId());
        List<String> tempList = new ArrayList<String>();
        if (this.links.containsKey(npc.getId())) {
            tempList = this.links.get(npc.getId());
        }
        tempList.add(notableName.toUpperCase());
        this.links.put(npc.getId(), tempList);
        this.saveNotables();
        return true;
    }

    public boolean addNotable(String name, Location location) {
        Notable newNotable = new Notable(name, location);
        if (this.notables.contains(newNotable)) {
            return false;
        }
        this.notables.add(newNotable);
        this.saveNotables();
        return true;
    }

    public Notable getNotable(String name) {
        for (Notable notable : this.notables) {
            if (!notable.getName().equalsIgnoreCase(name)) continue;
            return notable;
        }
        return null;
    }

    public List<Notable> getNotables() {
        return this.notables;
    }

    public void loadNotables() {
        List notablesList = this.denizen.getSaves().getStringList("Notables.List");
        if (notablesList.isEmpty()) {
            return;
        }
        this.notables.clear();
        for (String notable : notablesList) {
            String[] ns = notable.split(";");
            this.notables.add(new Notable(ns[0], new Location(Bukkit.getServer().getWorld(ns[1]), Double.valueOf(ns[2]).doubleValue(), Double.valueOf(ns[3]).doubleValue(), Double.valueOf(ns[4]).doubleValue())));
            if (ns.length <= 5) continue;
            for (int x = 5; x < ns.length; ++x) {
                try {
                    this.getNotable(ns[0]).addLink(Integer.valueOf(ns[x]));
                    List<String> tempList = new ArrayList<String>();
                    if (this.links.containsKey(Integer.valueOf(ns[x]))) {
                        tempList = this.links.get(Integer.valueOf(ns[x]));
                    }
                    tempList.add(ns[0]);
                    this.links.put(Integer.valueOf(ns[x]), tempList);
                    continue;
                }
                catch (Exception e) {
                    dB.echoDebug("Invalid NPC linked to Notable '%s'", ns[0]);
                }
            }
        }
    }

    public boolean removeLink(String notableName, NPC npc) {
        Notable notable = this.getNotable(notableName);
        if (notable == null) {
            return false;
        }
        this.getNotable(notableName).removeLink(npc.getId());
        List<Object> tempList = new ArrayList();
        if (this.links.containsKey(npc.getId())) {
            tempList = this.links.get(npc.getId());
        }
        tempList.remove(notableName.toUpperCase());
        this.links.put(npc.getId(), tempList);
        this.saveNotables();
        return true;
    }

    public boolean removeNotable(Notable notable) {
        if (this.notables.contains(notable)) {
            this.notables.remove(notable);
            return true;
        }
        return false;
    }

    public boolean removeNotable(String notableName) {
        Notable notable = this.getNotable(notableName);
        if (notable == null) {
            return false;
        }
        this.removeNotable(notable);
        return true;
    }

    public void saveNotables() {
        ArrayList<String> notablesList = new ArrayList<String>();
        for (Notable notable : this.notables) {
            notablesList.add(notable.stringValue());
        }
        this.denizen.getSaves().set("Notables.List", notablesList);
    }
}

