/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.npc.activities.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizen.npc.DenizenNPC;
import net.aufdemrand.denizen.npc.activities.AbstractActivity;
import net.aufdemrand.denizen.npc.activities.core.TaskGoal;
import net.aufdemrand.denizen.scripts.helpers.ArgumentHelper;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.ai.Goal;

public class TaskActivity
extends AbstractActivity {
    private Map<DenizenNPC, List<TaskGoal>> taskMap = new HashMap<DenizenNPC, List<TaskGoal>>();

    public boolean addGoal(DenizenNPC denizenNPC, String[] arguments, int priority) {
        dB.echoDebug("Adding TASK Activity.");
        int delay = 60;
        int repeats = -1;
        String script = null;
        int duration = 50;
        for (String arg : arguments) {
            if (this.aH.matchesValueArg("DELAY", arg, ArgumentHelper.ArgumentType.Integer)) {
                delay = this.aH.getIntegerFrom(arg);
                continue;
            }
            if (this.aH.matchesValueArg("REPEATS", arg, ArgumentHelper.ArgumentType.Integer)) {
                repeats = this.aH.getIntegerFrom(arg);
                continue;
            }
            if (this.aH.matchesValueArg("DURATION", arg, ArgumentHelper.ArgumentType.Integer)) {
                duration = this.aH.getIntegerFrom(arg);
                continue;
            }
            if (this.aH.matchesScript(arg)) {
                script = this.aH.getStringFrom(arg);
                continue;
            }
            dB.echoError("Could not match argument '%s'.", arg);
        }
        if (script == null) {
            dB.echoError("No script defined!");
            return false;
        }
        List<TaskGoal> taskGoals = new ArrayList<TaskGoal>();
        if (this.taskMap.containsKey(denizenNPC)) {
            taskGoals = this.taskMap.get(denizenNPC);
        }
        taskGoals.add(0, new TaskGoal(denizenNPC, delay, duration, script, repeats, this));
        this.taskMap.put(denizenNPC, taskGoals);
        denizenNPC.getCitizen().getDefaultGoalController().addGoal((Goal)this.taskMap.get(denizenNPC).get(0), priority);
        return true;
    }

    public boolean removeGoal(DenizenNPC denizenNPC, boolean verbose) {
        if (this.taskMap.containsKey(denizenNPC)) {
            for (TaskGoal goal : this.taskMap.get(denizenNPC)) {
                denizenNPC.getCitizen().getDefaultGoalController().removeGoal((Goal)goal);
            }
            this.taskMap.remove(denizenNPC);
            if (verbose) {
                dB.log("Removed Task Activity from NPC.");
            }
            return true;
        }
        if (verbose) {
            dB.log("NPC does not have this activity!");
        }
        return false;
    }

    public void onEnable() {
    }
}

