/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.npc.traits;

import java.util.HashMap;
import java.util.Map;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.events.ScriptsReloadEvent;
import net.aufdemrand.denizen.npc.traits.AssignmentTrait;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.command.exception.CommandException;
import net.citizensnpcs.util.Paginator;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantsTrait
extends Trait {
    private Denizen denizen;
    private Map<String, String> constants = new HashMap<String, String>();
    private Map<String, String> assignmentConstants = new HashMap<String, String>();
    private String assignment = null;

    public ConstantsTrait() {
        super("constants");
        this.denizen = (Denizen)Bukkit.getServer().getPluginManager().getPlugin("Denizen");
    }

    public void load(DataKey key) throws NPCLoadException {
        if (this.denizen == null) {
            this.denizen = (Denizen)Bukkit.getServer().getPluginManager().getPlugin("Denizen");
        }
        for (DataKey keyToLoad : key.getSubKeys()) {
            this.constants.put(keyToLoad.name().toLowerCase(), keyToLoad.getString(""));
        }
    }

    public void save(DataKey key) {
        for (Map.Entry<String, String> entry : this.constants.entrySet()) {
            key.setString(entry.getKey().toLowerCase(), entry.getValue());
        }
    }

    public String getConstant(String name) {
        if (this.constants.containsKey(name.toLowerCase())) {
            return this.constants.get(name.toLowerCase());
        }
        if (this.getAssignmentConstants().containsKey(name.toLowerCase())) {
            return this.assignmentConstants.get(name.toLowerCase());
        }
        return null;
    }

    public void setConstant(String name, String value) {
        this.constants.put(name.toLowerCase(), value);
    }

    public void removeConstant(String name) {
        if (this.constants.containsKey(name.toLowerCase())) {
            this.constants.remove(name.toLowerCase());
        }
    }

    public boolean hasNPCConstants() {
        return !this.constants.isEmpty();
    }

    public void describe(CommandSender sender, int page) throws CommandException {
        Paginator paginator = new Paginator().header("Constants for " + this.npc.getName());
        paginator.addLine("<e>NPC-specific constants: " + (this.hasNPCConstants() ? "" : "None.") + "");
        if (this.hasNPCConstants()) {
            paginator.addLine("<e>Key: <a>Name  <b>Value");
        }
        for (Map.Entry<String, String> constant : this.constants.entrySet()) {
            paginator.addLine("<a> " + String.valueOf(constant.getKey().charAt(0)).toUpperCase() + constant.getKey().substring(1) + "<b>  " + constant.getValue());
        }
        paginator.addLine("");
        if (this.npc.hasTrait(AssignmentTrait.class) && ((AssignmentTrait)this.npc.getTrait(AssignmentTrait.class)).hasAssignment()) {
            this.getAssignmentConstants();
            paginator.addLine("<e>Constants for assignment '" + this.assignment.toUpperCase() + "':");
            paginator.addLine("<e>Key: <a>Name  <b>Value");
            for (Map.Entry<String, String> constant : this.getAssignmentConstants().entrySet()) {
                if (this.constants.containsKey(constant.getKey())) {
                    paginator.addLine("<m>" + String.valueOf(constant.getKey().charAt(0)).toUpperCase() + constant.getKey().substring(1) + "<r>  <m>" + constant.getValue());
                    continue;
                }
                paginator.addLine("<a>" + String.valueOf(constant.getKey().charAt(0)).toUpperCase() + constant.getKey().substring(1) + "<b>  " + constant.getValue());
            }
            paginator.addLine("");
        }
        if (!paginator.sendPage(sender, page)) {
            throw new CommandException("citizens.commands.page-missing", new Object[]{page});
        }
    }

    public Map<String, String> getAssignmentConstants() {
        if (this.npc.hasTrait(AssignmentTrait.class) && ((AssignmentTrait)this.npc.getTrait(AssignmentTrait.class)).hasAssignment()) {
            if (this.assignment != null && this.assignment.equalsIgnoreCase(((AssignmentTrait)this.npc.getTrait(AssignmentTrait.class)).getAssignment())) {
                return this.assignmentConstants;
            }
            return this.rebuildAssignmentConstants();
        }
        return this.assignmentConstants;
    }

    private Map<String, String> rebuildAssignmentConstants() {
        if (!this.npc.hasTrait(AssignmentTrait.class)) {
            this.assignmentConstants.clear();
            return this.assignmentConstants;
        }
        this.assignment = ((AssignmentTrait)this.npc.getTrait(AssignmentTrait.class)).getAssignment();
        this.assignmentConstants.clear();
        if (this.denizen.getScripts().contains(this.assignment.toUpperCase() + ".DEFAULT CONSTANTS")) {
            for (String constant : this.denizen.getScripts().getConfigurationSection(this.assignment.toUpperCase() + ".DEFAULT CONSTANTS").getKeys(false)) {
                this.assignmentConstants.put(constant.toLowerCase(), this.denizen.getScripts().getString(this.assignment.toUpperCase() + ".DEFAULT CONSTANTS." + constant.toUpperCase(), ""));
            }
        }
        return this.assignmentConstants;
    }

    @EventHandler
    public void onScriptsReload(ScriptsReloadEvent event) {
        this.rebuildAssignmentConstants();
    }
}

