/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.npc.traits;

import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;
import org.bukkit.craftbukkit.v1_4_6.entity.CraftLivingEntity;
import org.bukkit.event.Listener;

public class HealthTrait
extends Trait
implements Listener {
    private int maxHealth = 20;
    private int rememberedHealth = -1;

    public HealthTrait() {
        super("health");
    }

    public void load(DataKey key) throws NPCLoadException {
        this.maxHealth = key.getInt("maxhealth", 20);
        this.rememberedHealth = key.getInt("currenthealth", this.maxHealth);
    }

    public void save(DataKey key) {
        key.setInt("maxhealth", this.maxHealth);
        key.setInt("currenthealth", this.rememberedHealth);
    }

    public void onSpawn() {
        if (this.rememberedHealth > 0) {
            this.setHealth(this.rememberedHealth);
        } else {
            this.setHealth();
        }
    }

    public void onDespawn() {
        if (this.getHealth() > 0) {
            this.rememberedHealth = this.getHealth();
        }
    }

    public void setMaxHealth(int newMax) {
        this.maxHealth = newMax;
    }

    public void heal(int health) {
        this.setHealth(this.getHealth() + health);
    }

    public int getMaxHealth() {
        return this.maxHealth;
    }

    public void setHealth() {
        this.setHealth(this.maxHealth);
    }

    public void setHealth(int health) {
        ((CraftLivingEntity)this.npc.getBukkitEntity()).getHandle().setHealth(health);
        this.rememberedHealth = -1;
    }

    public int getHealth() {
        return ((CraftLivingEntity)this.npc.getBukkitEntity()).getHandle().getHealth();
    }
}

