/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.npc.traits;

import net.aufdemrand.denizen.Denizen;
import net.citizensnpcs.api.ai.event.NavigationCompleteEvent;
import net.citizensnpcs.api.event.NPCPushEvent;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;
import net.minecraft.server.v1_4_6.EntityLiving;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_4_6.entity.CraftLivingEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class PushableTrait
extends Trait
implements Listener {
    private boolean pushable = true;
    private boolean returnable = false;
    private boolean pushed = false;
    private Location returnLocation = null;
    private Denizen denizen = (Denizen)Bukkit.getServer().getPluginManager().getPlugin("Denizen");
    private long pushedTimer = 0L;
    private int delay = 2;

    public PushableTrait() {
        super("pushable");
    }

    public void load(DataKey key) throws NPCLoadException {
        this.pushable = key.getBoolean("toggled", true);
        this.returnable = key.getBoolean("returnable", false);
        this.delay = key.getInt("delay", 2);
    }

    public void save(DataKey key) {
        key.setBoolean("toggled", this.pushable);
        key.setBoolean("returnable", this.returnable);
        key.setInt("delay", this.delay);
    }

    public int getDelay() {
        return this.delay;
    }

    public boolean isPushable() {
        return this.pushable;
    }

    public boolean isReturnable() {
        return this.returnable;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public void setPushable(boolean pushable) {
        this.pushable = pushable;
    }

    public void setReturnable(boolean returnable) {
        this.returnable = returnable;
    }

    public boolean toggle() {
        boolean bl = this.pushable = !this.pushable;
        if (!this.pushable) {
            this.returnable = false;
        }
        return this.pushable;
    }

    @EventHandler
    public void NPCPush(NPCPushEvent event) {
        if (event.getNPC() == this.npc && this.pushable) {
            event.setCancelled(false);
            if (System.currentTimeMillis() > this.pushedTimer) {
                Player pusher = null;
                for (Entity le : ((CraftLivingEntity)event.getNPC().getBukkitEntity()).getNearbyEntities(1.0, 1.0, 1.0)) {
                    if (!(le instanceof Player)) continue;
                    pusher = (Player)le;
                }
                if (pusher != null) {
                    this.denizen.getNPCRegistry().getDenizen(this.npc).action("push", pusher);
                    this.pushedTimer = System.currentTimeMillis() + (long)(this.delay * 1000);
                }
            }
            if (!this.pushed && this.returnable) {
                this.pushed = true;
                this.returnLocation = this.npc.getBukkitEntity().getLocation().clone();
                this.denizen.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.denizen, new Runnable(){

                    public void run() {
                        PushableTrait.this.navigateBack();
                    }
                }, (long)(this.delay * 20));
            }
        }
    }

    @EventHandler
    public void NPCCompleteDestination(NavigationCompleteEvent event) {
        if (event.getNPC() == this.npc && this.pushed) {
            EntityLiving handle = ((CraftLivingEntity)this.npc.getBukkitEntity()).getHandle();
            handle.yaw = this.returnLocation.getYaw();
            handle.pitch = this.returnLocation.getPitch();
            handle.az = handle.yaw;
            this.pushed = false;
            this.denizen.getNPCRegistry().getDenizen(this.npc).action("push return", null);
        }
    }

    protected void navigateBack() {
        if (this.npc.getNavigator().isNavigating()) {
            this.pushed = false;
            return;
        }
        if (this.pushed) {
            this.pushed = false;
            this.npc.getNavigator().setTarget(this.returnLocation);
            this.pushed = true;
        }
    }
}

