/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.scripts.helpers.ArgumentHelper;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.speech.SpeechContext;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class ChatCommand
extends AbstractCommand {
    SpeechContext context = null;

    public void onEnable() {
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        this.context = new SpeechContext("");
        if (scriptEntry.getNPC() != null) {
            this.context.setTalker(scriptEntry.getNPC().getEntity());
        }
        for (String arg : scriptEntry.getArguments()) {
            if (this.aH.matchesValueArg("TARGET, TARGETS", arg, ArgumentHelper.ArgumentType.Custom)) {
                for (String target : this.aH.getListFrom(arg)) {
                    if (target.matches("\\d+")) {
                        NPC npc = CitizensAPI.getNPCRegistry().getById(Integer.valueOf(target).intValue());
                        if (npc != null) {
                            this.context.addRecipient(npc.getBukkitEntity());
                            continue;
                        }
                    } else {
                        Player player = Bukkit.getPlayer((String)target);
                        if (player != null) {
                            this.context.addRecipient((LivingEntity)player);
                            continue;
                        }
                    }
                    dB.echoError("Invalid TARGET '%s'!", target);
                }
                dB.echoDebug("Set TARGET(s).");
                continue;
            }
            if (this.aH.matchesValueArg("TALKER", arg, ArgumentHelper.ArgumentType.Custom)) {
                NPC npc;
                String talker = this.aH.getStringFrom(arg);
                if (talker.matches("\\d+") && (npc = CitizensAPI.getNPCRegistry().getById(Integer.valueOf(talker).intValue())) != null) {
                    dB.echoDebug("...set TALKER: '%s'", talker);
                    this.context.setTalker(npc.getBukkitEntity());
                    continue;
                }
                dB.echoError("Invalid TALKER! Perhaps the NPC doesn't exist?");
                continue;
            }
            this.context.setMessage(arg);
            dB.echoDebug(dB.Messages.DEBUG_SET_TEXT, arg);
        }
        if (this.context.getTalker() == null) {
            throw new InvalidArgumentsException("Must specify a valid TalkableEntity for TALKER!");
        }
    }

    public void execute(String commandName) throws CommandExecutionException {
        if (CitizensAPI.getNPCRegistry().isNPC((Entity)this.context.getTalker().getEntity())) {
            CitizensAPI.getNPCRegistry().getNPC((Entity)this.context.getTalker().getEntity()).getDefaultSpeechController().speak(this.context, "chat");
        }
    }
}

