/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.HashMap;
import java.util.Map;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.npc.NPC;

public class EngageCommand
extends AbstractCommand {
    int duration;
    NPC npc;
    private Map<NPC, Long> currentlyEngaged = new HashMap<NPC, Long>();

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        this.duration = 1;
        if (scriptEntry.getNPC() == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_NO_NPCID);
        }
        this.npc = scriptEntry.getNPC().getCitizen();
        for (String arg : scriptEntry.getArguments()) {
            if (this.aH.matchesInteger(arg) || this.aH.matchesDuration(arg)) {
                this.duration = this.aH.getIntegerFrom(arg);
                dB.echoDebug(dB.Messages.DEBUG_SET_DURATION, arg);
                continue;
            }
            if (this.aH.matchesArg("NOW", arg)) continue;
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT);
        }
    }

    public void execute(String commandName) throws CommandExecutionException {
        if (this.duration > 0) {
            this.setEngaged(this.npc, this.duration);
        } else {
            this.setEngaged(this.npc, true);
        }
    }

    public boolean getEngaged(NPC npc) {
        return this.currentlyEngaged.containsKey(npc) && this.currentlyEngaged.get(npc) > System.currentTimeMillis();
    }

    public void setEngaged(NPC npc, boolean engaged) {
        if (engaged) {
            this.currentlyEngaged.put(npc, System.currentTimeMillis() + (long)(Denizen.settings.EngageTimeoutInSeconds() * 1000));
        }
        if (!engaged) {
            this.currentlyEngaged.remove(npc);
        }
    }

    public void setEngaged(NPC npc, Integer duration) {
        this.currentlyEngaged.put(npc, System.currentTimeMillis() + (long)(duration * 1000));
    }

    public void onEnable() {
    }
}

