/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.events.ScriptFinishEvent;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

public class FinishCommand
extends AbstractCommand {
    String scriptName;
    String playerName;

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        this.scriptName = scriptEntry.getScript();
        this.playerName = null;
        if (scriptEntry.getPlayer() != null) {
            this.playerName = scriptEntry.getPlayer().getName();
        }
        for (String arg : scriptEntry.getArguments()) {
            if (this.aH.matchesScript(arg)) {
                this.scriptName = this.aH.getStringFrom(arg);
                dB.echoDebug(dB.Messages.DEBUG_SET_SCRIPT, arg);
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (this.playerName == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_NO_PLAYER);
        }
        if (this.scriptName == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_NO_SCRIPT);
        }
    }

    public void execute(String commandName) throws CommandExecutionException {
        this.finishScript(this.playerName, this.scriptName);
    }

    public boolean finishScript(String playerName, String scriptName) {
        scriptName = scriptName.toUpperCase();
        int finishes = this.denizen.getSaves().getInt("Players." + playerName.toUpperCase() + "." + scriptName + "." + "Completed", 0);
        this.denizen.getSaves().set("Players." + playerName.toUpperCase() + "." + scriptName + "." + "Completed", (Object)(++finishes));
        this.denizen.saveSaves();
        ScriptFinishEvent event = new ScriptFinishEvent(playerName, scriptName, finishes);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        return true;
    }

    public int getScriptCompletes(String playerName, String scriptName) {
        return this.denizen.getSaves().getInt("Players." + playerName.toUpperCase() + "." + scriptName.toUpperCase() + "." + "Failed", 0);
    }

    public void onEnable() {
    }
}

