/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.ArrayList;
import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.exceptions.ScriptEntryCreationException;
import net.aufdemrand.denizen.npc.DenizenNPC;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import org.bukkit.entity.Player;

public class IfCommand
extends AbstractCommand {
    List<Comparable> comparables = new ArrayList<Comparable>();
    String outcomeCommand;
    List<String> outcomeArgs = new ArrayList<String>();
    String elseCommand;
    List<String> elseArgs = new ArrayList<String>();
    Player player;
    DenizenNPC npc;
    String script;
    String step;

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        this.comparables.clear();
        this.outcomeCommand = null;
        this.outcomeArgs.clear();
        this.elseCommand = null;
        this.elseArgs.clear();
        this.player = scriptEntry.getPlayer();
        this.npc = scriptEntry.getNPC();
        this.script = scriptEntry.getScript();
        this.step = scriptEntry.getStep();
        this.comparables.add(new Comparable());
        int index = 0;
        for (String arg : scriptEntry.getArguments()) {
            if (this.outcomeCommand == null) {
                if (arg.startsWith("!")) {
                    this.comparables.get((int)index).logic = Logic.NEGATIVE;
                    arg = arg.substring(1);
                }
                if (this.aH.matchesArg("OR", arg = arg.replace("==", "EQUALS").replace("<", "LESS").replace(">", "MORE").replace("=", "EQUALS").replace(">=", "ORMORE").replace("<=", "ORLESS")) || this.aH.matchesArg("AND", arg)) {
                    this.comparables.add(new Comparable());
                    this.comparables.get((int)(++index)).bridge = Bridge.valueOf(arg.toUpperCase());
                    continue;
                }
                if (this.aH.matchesArg("EQUALS", arg) || this.aH.matchesArg("ISINT", arg) || this.aH.matchesArg("ISDOUBLE", arg) || this.aH.matchesArg("ISPLAYER", arg) || this.aH.matchesArg("ISEMPTY", arg) || this.aH.matchesArg("ORMORE", arg) || this.aH.matchesArg("MORE", arg) || this.aH.matchesArg("LESS", arg) || this.aH.matchesArg("ORLESS", arg) || this.aH.matchesArg("CONTAINS", arg)) {
                    this.comparables.get((int)index).operator = Operator.valueOf(arg.toUpperCase());
                    continue;
                }
                if (this.denizen.getCommandRegistry().get(arg) != null) {
                    this.outcomeCommand = arg;
                    continue;
                }
                if (this.comparables.get((int)index).comparable == null) {
                    this.comparables.get((int)index).comparable = this.findObjectType(arg);
                    continue;
                }
                this.comparables.get((int)index).comparedto = this.findObjectType(arg);
                continue;
            }
            if (this.elseCommand == null) {
                if (this.aH.matchesArg("ELSE", arg)) {
                    this.elseCommand = "";
                    continue;
                }
                this.outcomeArgs.add(arg);
                continue;
            }
            if (this.elseCommand.equals("")) {
                this.elseCommand = arg;
                continue;
            }
            this.elseArgs.add(arg);
        }
    }

    public void execute(String commandName) throws CommandExecutionException {
        for (Comparable com : this.comparables) {
            block53: {
                block55: {
                    block54: {
                        com.outcome = false;
                        if (!(com.comparable instanceof String)) break block54;
                        block0 : switch (com.operator) {
                            case ISEMPTY: {
                                if (!((String)com.comparable).equals("EMPTY")) break;
                                com.outcome = true;
                                break;
                            }
                            case EQUALS: {
                                if (!((String)com.comparable).equalsIgnoreCase((String)com.comparedto)) break;
                                com.outcome = true;
                                break;
                            }
                            case CONTAINS: {
                                if (!((String)com.comparable).toUpperCase().contains(((String)com.comparedto).toUpperCase())) break;
                                com.outcome = true;
                                break;
                            }
                            case ORMORE: {
                                if (((String)com.comparable).length() < ((String)com.comparedto).length()) break;
                                com.outcome = true;
                                break;
                            }
                            case ORLESS: {
                                if (((String)com.comparable).length() > ((String)com.comparedto).length()) break;
                                com.outcome = true;
                                break;
                            }
                            case MORE: {
                                if (((String)com.comparable).length() <= ((String)com.comparedto).length()) break;
                                com.outcome = true;
                                break;
                            }
                            case LESS: {
                                if (((String)com.comparable).length() >= ((String)com.comparedto).length()) break;
                                com.outcome = true;
                                break;
                            }
                            case ISPLAYER: {
                                for (Player player : this.denizen.getServer().getOnlinePlayers()) {
                                    if (!player.getName().equalsIgnoreCase((String)com.comparable)) continue;
                                    com.outcome = true;
                                    break;
                                }
                                if (com.outcome.booleanValue()) break;
                                for (Player player : this.denizen.getServer().getOfflinePlayers()) {
                                    if (!player.getName().equalsIgnoreCase((String)com.comparable)) continue;
                                    com.outcome = true;
                                    break block0;
                                }
                                break;
                            }
                        }
                        break block53;
                    }
                    if (!(com.comparable instanceof List)) break block55;
                    block10 : switch (com.operator) {
                        case CONTAINS: {
                            for (String string : (List)com.comparable) {
                                if (com.comparedto instanceof Integer) {
                                    if (this.aH.getIntegerFrom(string) == ((Integer)com.comparedto).intValue()) {
                                        com.outcome = true;
                                        break block10;
                                    }
                                } else if (com.comparedto instanceof Double) {
                                    if (this.aH.getDoubleFrom(string) == ((Double)com.comparedto).doubleValue()) {
                                        com.outcome = true;
                                        break block10;
                                    }
                                } else if (com.comparedto instanceof Boolean) {
                                    if (Boolean.valueOf(string).booleanValue() == ((Boolean)com.comparedto).booleanValue()) {
                                        com.outcome = true;
                                        break block10;
                                    }
                                } else {
                                    if (!(com.comparedto instanceof String)) continue;
                                    if (string.equalsIgnoreCase((String)com.comparedto)) {
                                        com.outcome = true;
                                        break block10;
                                    }
                                }
                                break block53;
                            }
                            break block53;
                        }
                        case ORMORE: {
                            if (((List)com.comparable).size() < (Integer)com.comparedto) break;
                            com.outcome = true;
                            break;
                        }
                        case ORLESS: {
                            if (((List)com.comparable).size() > (Integer)com.comparedto) break;
                            com.outcome = true;
                        }
                    }
                    break block53;
                }
                if (com.comparable instanceof Double) {
                    switch (com.operator) {
                        case EQUALS: {
                            if (((Double)com.comparable).compareTo((Double)com.comparedto) != 0) break;
                            com.outcome = true;
                            break;
                        }
                        case ORMORE: {
                            if (((Double)com.comparable).compareTo((Double)com.comparedto) < 0) break;
                            com.outcome = true;
                            break;
                        }
                        case ORLESS: {
                            if (((Double)com.comparable).compareTo((Double)com.comparedto) > 0) break;
                            com.outcome = true;
                            break;
                        }
                        case MORE: {
                            if (((Double)com.comparable).compareTo((Double)com.comparedto) <= 0) break;
                            com.outcome = true;
                            break;
                        }
                        case LESS: {
                            if (((Double)com.comparable).compareTo((Double)com.comparedto) >= 0) break;
                            com.outcome = true;
                        }
                    }
                } else if (com.comparable instanceof Integer) {
                    switch (com.operator) {
                        case EQUALS: {
                            if (((Integer)com.comparable).compareTo((Integer)com.comparedto) != 0) break;
                            com.outcome = true;
                            break;
                        }
                        case ORMORE: {
                            if (((Integer)com.comparable).compareTo((Integer)com.comparedto) < 0) break;
                            com.outcome = true;
                            break;
                        }
                        case ORLESS: {
                            if (((Integer)com.comparable).compareTo((Integer)com.comparedto) > 0) break;
                            com.outcome = true;
                            break;
                        }
                        case MORE: {
                            if (((Integer)com.comparable).compareTo((Integer)com.comparedto) <= 0) break;
                            com.outcome = true;
                            break;
                        }
                        case LESS: {
                            if (((Integer)com.comparable).compareTo((Integer)com.comparedto) >= 0) break;
                            com.outcome = true;
                        }
                    }
                } else if (com.comparable instanceof Boolean) {
                    com.outcome = (boolean)((Boolean)com.comparable);
                }
            }
            if (com.logic != Logic.NEGATIVE) continue;
            com.outcome = com.outcome == false;
        }
        int ormet = 0;
        for (Comparable compareable : this.comparables) {
            if (compareable.bridge != Bridge.OR || !compareable.outcome.booleanValue()) continue;
            ++ormet;
        }
        int andcount = 0;
        int andmet = 0;
        for (Comparable compareable : this.comparables) {
            if (compareable.bridge == Bridge.AND && compareable.outcome.booleanValue()) {
                ++andmet;
            }
            ++andcount;
        }
        if (ormet > 0 && andcount == andmet) {
            this.doCommand();
        } else {
            this.doElse();
        }
    }

    private Object findObjectType(String arg) {
        if (this.aH.matchesInteger(arg)) {
            return this.aH.getIntegerFrom(arg);
        }
        if (this.aH.matchesDouble(arg)) {
            return this.aH.getDoubleFrom(arg);
        }
        if (arg.equalsIgnoreCase("true")) {
            return true;
        }
        if (arg.equalsIgnoreCase("false")) {
            return false;
        }
        if (arg.contains("|")) {
            ArrayList<String> toList = new ArrayList<String>();
            for (String string : arg.split("|")) {
                toList.add(string);
            }
            return toList;
        }
        return arg;
    }

    private void doCommand() {
        try {
            this.denizen.getScriptEngine().getScriptExecuter().execute(new ScriptEntry(this.outcomeCommand.toUpperCase(), (String[])this.outcomeArgs.toArray(), this.player, this.npc, this.script, this.step));
        }
        catch (ScriptEntryCreationException e) {
            e.printStackTrace();
        }
    }

    private void doElse() {
        try {
            this.denizen.getScriptEngine().getScriptExecuter().execute(new ScriptEntry(this.elseCommand.toUpperCase(), (String[])this.elseArgs.toArray(), this.player, this.npc, this.script, this.step));
        }
        catch (ScriptEntryCreationException e) {
            e.printStackTrace();
        }
    }

    public void onEnable() {
    }

    private class Comparable {
        Logic logic = Logic.REGULAR;
        Bridge bridge = Bridge.OR;
        Object comparable = null;
        Operator operator = Operator.EQUALS;
        Object comparedto = true;
        Boolean outcome = null;

        private Comparable() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Logic {
        REGULAR,
        NEGATIVE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Bridge {
        OR,
        AND,
        FIRST;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Operator {
        EQUALS,
        ISINT,
        ISDOUBLE,
        ISPLAYER,
        ORMORE,
        ORLESS,
        MORE,
        LESS,
        CONTAINS,
        ISEMPTY;

    }
}

