/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.scripts.helpers.ArgumentHelper;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Location;
import org.bukkit.Sound;

public class PlaySoundCommand
extends AbstractCommand {
    Sound sound;
    Location location;
    private float volume;
    private float pitch;

    public void onEnable() {
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        this.location = null;
        this.sound = null;
        this.volume = 1.0f;
        this.pitch = 1.0f;
        for (String arg : scriptEntry.getArguments()) {
            if (this.aH.matchesLocation(arg)) {
                this.location = this.aH.getLocationFrom(arg);
                if (this.location == null) continue;
                dB.echoDebug(dB.Messages.DEBUG_SET_LOCATION, this.aH.getStringFrom(arg));
                continue;
            }
            if (this.aH.matchesValueArg("SOUND", arg, ArgumentHelper.ArgumentType.Custom) || this.aH.matchesValueArg("S", arg, ArgumentHelper.ArgumentType.Custom)) {
                try {
                    this.sound = Sound.valueOf((String)this.aH.getStringFrom(arg));
                    dB.echoDebug("...SOUND set to: " + this.sound.name());
                }
                catch (Exception e) {
                    dB.echoError("Invalid SOUND!");
                }
                continue;
            }
            if (this.aH.matchesValueArg("VOLUME", arg, ArgumentHelper.ArgumentType.Float) || this.aH.matchesValueArg("V", arg, ArgumentHelper.ArgumentType.Float)) {
                this.volume = this.aH.getFloatFrom(arg);
                dB.echoDebug("...VOLUME set to: " + this.volume);
                continue;
            }
            if (this.aH.matchesValueArg("PITCH", arg, ArgumentHelper.ArgumentType.Float) || this.aH.matchesValueArg("P", arg, ArgumentHelper.ArgumentType.Float)) {
                this.pitch = this.aH.getFloatFrom(arg);
                dB.echoDebug("...PITCH set to: " + this.pitch);
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (this.sound == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "SOUND");
        }
        if (this.location == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "LOCATION");
        }
    }

    public void execute(String commandName) throws CommandExecutionException {
        dB.echoDebug("...playing sound.");
        this.location.getWorld().playSound(this.location, this.sound, this.volume, this.pitch);
    }
}

