/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.npc.traits.TriggerTrait;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.scripts.helpers.ArgumentHelper;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.npc.NPC;

public class TriggerCommand
extends AbstractCommand {
    String triggerName;
    Boolean toggle;
    Double cooldown;
    Integer radius;
    NPC npc;

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        this.triggerName = null;
        this.toggle = null;
        this.cooldown = null;
        this.radius = null;
        this.npc = null;
        if (scriptEntry.getNPC() != null) {
            this.npc = scriptEntry.getNPC().getCitizen();
        }
        for (String arg : scriptEntry.getArguments()) {
            if (this.aH.matchesValueArg("COOLDOWN", arg, ArgumentHelper.ArgumentType.Double)) {
                this.cooldown = this.aH.getDoubleFrom(arg);
                dB.echoDebug(dB.Messages.DEBUG_SET_COOLDOWN, String.valueOf(this.cooldown));
                continue;
            }
            if (this.aH.matchesValueArg("NAME", arg, ArgumentHelper.ArgumentType.String)) {
                this.triggerName = this.aH.getStringFrom(arg);
                dB.echoDebug(dB.Messages.DEBUG_SET_NAME, this.triggerName);
                continue;
            }
            if (this.aH.matchesValueArg("RADIUS", arg, ArgumentHelper.ArgumentType.Integer)) {
                this.radius = this.aH.getIntegerFrom(arg);
                dB.echoDebug(dB.Messages.DEBUG_SET_RADIUS, String.valueOf(this.radius));
                continue;
            }
            if (this.aH.matchesToggle(arg)) {
                this.toggle = this.aH.getBooleanFrom(arg);
                dB.echoDebug(dB.Messages.DEBUG_TOGGLE, String.valueOf(this.toggle));
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (this.triggerName == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "NAME");
        }
        if (this.radius == null && this.toggle == null && this.cooldown == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "RADIUS, COOLDOWN or TOGGLE");
        }
    }

    public void execute(String commandName) throws CommandExecutionException {
        if (this.npc == null) {
            throw new CommandExecutionException(dB.Messages.ERROR_NO_NPCID);
        }
        if (!this.npc.hasTrait(TriggerTrait.class)) {
            this.npc.addTrait(TriggerTrait.class);
        }
        TriggerTrait trait = (TriggerTrait)this.npc.getTrait(TriggerTrait.class);
        if (this.radius != null) {
            trait.setLocalRadius(this.triggerName, this.radius);
        }
        if (this.toggle != null) {
            trait.toggleTrigger(this.triggerName);
        }
        if (this.cooldown != null) {
            trait.setLocalCooldown(this.triggerName, this.cooldown);
        }
    }

    public void onEnable() {
    }
}

