/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.helpers;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.scripts.ScriptEngine;
import net.aufdemrand.denizen.scripts.commands.core.NewCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentHelper {
    Denizen denizen;
    final Pattern durationPattern = Pattern.compile("duration:(\\d+)", 2);
    final Pattern scriptPattern = Pattern.compile("script:.+", 2);
    final Pattern locationPattern = Pattern.compile("location:(?:-|)\\d+,(?:-|)\\d+,(?:-|)\\d+,\\w+", 2);
    final Pattern queuetypePattern = Pattern.compile("(?:queue|queuetype):(?:player|player_task|npc)", 2);
    final Pattern quantityPattern = Pattern.compile("qty:(?:-|)\\d+", 2);
    final Pattern togglePattern = Pattern.compile("toggle:(true|false)", 2);
    final Pattern newItemPattern = Pattern.compile("item:itemstack\\..+", 2);
    final Pattern materialPattern = Pattern.compile("item:[a-zA-Z\\x5F]+", 2);
    final Pattern materialDataPattern = Pattern.compile("item:[a-zA-Z]+?:\\d+", 2);
    final Pattern itemIdPattern = Pattern.compile("item:\\d+");
    final Pattern itemIdDataPattern = Pattern.compile("item:\\d+:\\d+");
    final Pattern integerPattern = Pattern.compile("(?:-|)\\d+");
    final Pattern doublePattern = Pattern.compile("(?:-|)\\d+(\\.\\d+|)");
    final Pattern floatPattern = Pattern.compile("^[-+]?[0-9]+[.]?[0-9]*([eE][-+]?[0-9]+)?$");
    final Pattern stringPattern = Pattern.compile(".+", 2);
    final Pattern wordPattern = Pattern.compile("\\w+", 2);
    Matcher m;

    public ArgumentHelper(Denizen denizen) {
        this.denizen = denizen;
    }

    public boolean matchesValueArg(String argumentNames, String argument, ArgumentType type) {
        if (argument == null) {
            return false;
        }
        if (argument.split(":").length == 1) {
            return false;
        }
        if (argumentNames.split(",").length == 1) {
            if (!argument.split(":")[0].equalsIgnoreCase(argumentNames)) {
                return false;
            }
        } else {
            boolean matched = false;
            for (String string : argumentNames.split(",")) {
                if (!argument.split(":")[0].equalsIgnoreCase(string.trim())) continue;
                matched = true;
            }
            if (!matched) {
                return false;
            }
        }
        argument = argument.split(":", 2)[1];
        switch (type) {
            case Word: {
                this.m = this.wordPattern.matcher(argument);
                return this.m.matches();
            }
            case Integer: {
                this.m = this.integerPattern.matcher(argument);
                return this.m.matches();
            }
            case Double: {
                this.m = this.doublePattern.matcher(argument);
                return this.m.matches();
            }
            case Float: {
                this.m = this.floatPattern.matcher(argument);
                return this.m.matches();
            }
            case Boolean: {
                return argument.equalsIgnoreCase("true");
            }
        }
        return true;
    }

    public boolean matchesArg(String names, String argument) {
        if (names.split(",").length == 1) {
            if (argument.toUpperCase().equals(names.toUpperCase())) {
                return true;
            }
        } else {
            for (String string : names.split(",")) {
                if (!argument.split(":")[0].equalsIgnoreCase(string.trim())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean matchesInteger(String argument) {
        this.m = this.integerPattern.matcher(argument);
        return this.m.matches();
    }

    public boolean matchesDouble(String argument) {
        this.m = this.doublePattern.matcher(argument);
        return this.m.matches();
    }

    public boolean matchesLocation(String argument) {
        this.m = this.locationPattern.matcher(argument);
        return this.m.matches();
    }

    public boolean matchesItem(String argument) {
        this.m = this.newItemPattern.matcher(argument);
        if (this.m.matches()) {
            return true;
        }
        this.m = this.itemIdPattern.matcher(argument);
        if (this.m.matches()) {
            return true;
        }
        this.m = this.itemIdDataPattern.matcher(argument);
        if (this.m.matches()) {
            return true;
        }
        this.m = this.materialPattern.matcher(argument);
        if (this.m.matches()) {
            for (Material mat : Material.values()) {
                if (!mat.name().equalsIgnoreCase(argument.substring(5))) continue;
                return true;
            }
        }
        this.m = this.materialDataPattern.matcher(argument);
        if (this.m.matches()) {
            if (argument.split(":").length == 2) {
                argument = argument.split(":")[0];
            }
            for (Material mat : Material.values()) {
                if (!mat.name().equalsIgnoreCase(argument)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean matchesDuration(String regex) {
        this.m = this.durationPattern.matcher(regex);
        return this.m.matches();
    }

    public boolean matchesToggle(String regex) {
        this.m = this.togglePattern.matcher(regex);
        return this.m.matches();
    }

    public boolean matchesQueueType(String regex) {
        this.m = this.queuetypePattern.matcher(regex);
        return this.m.matches();
    }

    public boolean matchesScript(String regex) {
        this.m = this.scriptPattern.matcher(regex);
        return this.m.matches() && this.denizen.getScripts().contains(regex.split(":")[1].toUpperCase() + ".TYPE");
    }

    public boolean matchesQuantity(String regex) {
        this.m = this.quantityPattern.matcher(regex);
        return this.m.matches();
    }

    public boolean getBooleanFrom(String argument) {
        if (argument.split(":").length >= 2) {
            return Boolean.valueOf(argument.split(":")[1]);
        }
        return false;
    }

    public String getStringFrom(String argument) {
        if (argument.split(":").length >= 2) {
            return argument.split(":")[1];
        }
        return argument;
    }

    public Player getPlayerFrom(String argument) {
        if (argument.split(":").length >= 2) {
            return this.denizen.getServer().getPlayer(argument.split(":")[1]);
        }
        return this.denizen.getServer().getPlayer(argument);
    }

    public Location getLocationFrom(String argument) {
        argument = argument.split(":", 2)[1];
        String[] num = argument.split(",");
        Location location = null;
        try {
            location = new Location(Bukkit.getWorld((String)num[3]), Double.valueOf(num[0]).doubleValue(), Double.valueOf(num[1]).doubleValue(), Double.valueOf(num[2]).doubleValue());
        }
        catch (Exception e) {
            dB.echoError("Invalid Location!");
            return null;
        }
        return location;
    }

    public List<String> getListFrom(String argument) {
        if (argument.split(":").length >= 2) {
            return Arrays.asList(argument.split(":")[1].split("\\|"));
        }
        return Arrays.asList(argument.split("\\|"));
    }

    public ScriptEngine.QueueType getQueueFrom(String argument) {
        try {
            if (argument.split(":").length >= 2) {
                return ScriptEngine.QueueType.valueOf(argument.split(":")[1].toUpperCase());
            }
            return ScriptEngine.QueueType.valueOf(argument.toUpperCase());
        }
        catch (Exception e) {
            dB.echoError("Invalid Queuetype!");
            return null;
        }
    }

    public int getIntegerFrom(String argument) {
        try {
            if (argument.split(":").length >= 2) {
                return Integer.valueOf(argument.split(":")[1]);
            }
            return Integer.valueOf(argument);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public float getFloatFrom(String argument) {
        try {
            if (argument.split(":").length >= 2) {
                return Float.valueOf(argument.split(":")[1]).floatValue();
            }
            return Float.valueOf(argument).floatValue();
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public double getDoubleFrom(String argument) {
        try {
            if (argument.split(":").length >= 2) {
                return Double.valueOf(argument.split(":")[1]);
            }
            return Double.valueOf(argument);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public ItemStack getItemFrom(String argument) {
        ItemStack stack;
        block11: {
            this.m = this.newItemPattern.matcher(argument);
            if (this.m.matches()) {
                String itemName = argument.split("\\.")[1].toUpperCase();
                if (this.denizen.getCommandRegistry().get(NewCommand.class).itemStacks.containsKey(itemName)) {
                    return this.denizen.getCommandRegistry().get(NewCommand.class).itemStacks.get(itemName);
                }
                dB.echoError("Invalid item!");
            }
            this.m = this.itemIdPattern.matcher(argument);
            Matcher m2 = this.itemIdDataPattern.matcher(argument);
            Matcher m3 = this.materialPattern.matcher(argument);
            Matcher m4 = this.materialDataPattern.matcher(argument);
            stack = null;
            try {
                if (this.m.matches()) {
                    stack = new ItemStack(Integer.valueOf(argument.substring(5)).intValue());
                } else if (m2.matches()) {
                    stack = new ItemStack(Integer.valueOf(argument.substring(5).split(":")[0]).intValue());
                    stack.setDurability(Short.valueOf(argument.substring(5).split(":")[1]).shortValue());
                } else if (m3.matches()) {
                    stack = new ItemStack(Material.valueOf((String)argument.substring(5).toUpperCase()));
                } else if (m4.matches()) {
                    stack = new ItemStack(Material.valueOf((String)argument.substring(5).split(":")[0].toUpperCase()));
                    stack.setDurability(Short.valueOf(argument.substring(5).split(":")[1]).shortValue());
                }
            }
            catch (Exception e) {
                dB.echoError("Invalid item!");
                if (!dB.showStackTraces) break block11;
                e.printStackTrace();
            }
        }
        return stack;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ArgumentType {
        String,
        Word,
        Integer,
        Double,
        Float,
        Boolean,
        Custom;

    }
}

