/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.triggers.core;

import java.util.List;
import net.aufdemrand.denizen.npc.DenizenNPC;
import net.aufdemrand.denizen.npc.traits.TriggerTrait;
import net.aufdemrand.denizen.scripts.ScriptEngine;
import net.aufdemrand.denizen.scripts.triggers.AbstractTrigger;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ClickTrigger
extends AbstractTrigger
implements Listener {
    @EventHandler
    public void clickTrigger(NPCRightClickEvent event) {
        if (!event.getNPC().hasTrait(TriggerTrait.class)) {
            return;
        }
        if (!((TriggerTrait)event.getNPC().getTrait(TriggerTrait.class)).isEnabled(this.name)) {
            return;
        }
        if (!((TriggerTrait)event.getNPC().getTrait(TriggerTrait.class)).trigger(this, event.getClicker())) {
            return;
        }
        String script = this.sH.getInteractScript(event.getNPC(), event.getClicker(), this.getClass());
        if (!this.parse(this.denizen.getNPCRegistry().getDenizen(event.getNPC()), event.getClicker(), script)) {
            this.denizen.getNPCRegistry().getDenizen(event.getNPC()).action("no click trigger", event.getClicker());
        }
    }

    public boolean parse(DenizenNPC npc, Player player, String script) {
        if (script == null) {
            return false;
        }
        dB.echoDebug(dB.DebugElement.Header, "Parsing click trigger: " + npc.getName() + "/" + player.getName());
        dB.echoDebug("Getting current step:");
        String theStep = this.sH.getCurrentStep(player, script);
        List<String> theScript = this.sH.getScriptContents(this.sH.getTriggerScriptPath(script, theStep, this.name) + this.sH.scriptKey);
        this.sB.queueScriptEntries(player, this.sB.buildScriptEntries(player, npc, theScript, script, theStep), ScriptEngine.QueueType.PLAYER);
        return true;
    }

    public void onEnable() {
        this.denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.denizen);
    }
}

