/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Location;
import org.bukkit.inventory.ItemStack;

public class DropCommand
extends AbstractCommand {
    ItemStack item;
    Location location;

    public void onEnable() {
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        this.item = null;
        Integer qty = null;
        this.location = null;
        for (String arg : scriptEntry.getArguments()) {
            if (this.aH.matchesItem(arg)) {
                this.item = this.aH.getItemFrom(arg);
                dB.echoDebug("...set ITEM: '%s'", this.aH.getStringFrom(arg));
                continue;
            }
            if (this.aH.matchesQuantity(arg)) {
                qty = this.aH.getIntegerFrom(arg);
                dB.echoDebug(dB.Messages.DEBUG_SET_QUANTITY, String.valueOf(qty));
                continue;
            }
            if (!this.aH.matchesLocation(arg)) continue;
            this.location = this.aH.getLocationFrom(arg);
            dB.echoDebug(dB.Messages.DEBUG_SET_LOCATION, this.aH.getStringFrom(arg));
        }
        if (this.item == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_INVALID_ITEM);
        }
        if (this.location == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_LOCATION);
        }
        if (qty != null) {
            this.item.setAmount(qty.intValue());
        }
    }

    public void execute(String commandName) throws CommandExecutionException {
        this.location.getWorld().dropItemNaturally(this.location, this.item);
    }
}

