/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.events.ReplaceableTagEvent;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.scripts.helpers.ArgumentHelper;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class NewCommand
extends AbstractCommand
implements Listener {
    public Map<String, ItemStack> itemStacks = new ConcurrentHashMap<String, ItemStack>();
    ObjectType objectType;
    String ID;
    long timeout = 0L;
    ItemStack item;

    public void onEnable() {
        this.denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.denizen);
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        this.item = null;
        this.objectType = null;
        int qty = 1;
        for (String arg : scriptEntry.getArguments()) {
            if (this.aH.matchesArg("ITEMSTACK, ENTITY, NPC", arg)) {
                this.objectType = ObjectType.valueOf(arg.toUpperCase());
                dB.echoDebug("...set NEW object type: '%s'", arg.toUpperCase());
                continue;
            }
            if (this.aH.matchesValueArg("ID", arg, ArgumentHelper.ArgumentType.String)) {
                this.ID = this.aH.getStringFrom(arg);
                dB.echoDebug("...set ID: '%s'", this.ID);
                continue;
            }
            if (this.aH.matchesItem(arg)) {
                this.item = this.aH.getItemFrom(arg);
                dB.echoDebug("...set ITEM: '%s'", this.aH.getStringFrom(arg));
                continue;
            }
            if (!this.aH.matchesQuantity(arg)) continue;
            qty = this.aH.getIntegerFrom(arg);
            dB.echoDebug(dB.Messages.DEBUG_SET_QUANTITY, String.valueOf(qty));
        }
        if (this.objectType == ObjectType.ITEMSTACK) {
            this.item.setAmount(qty);
        }
    }

    public void execute(String commandName) throws CommandExecutionException {
        if (this.objectType == ObjectType.ITEMSTACK) {
            this.itemStacks.put(this.ID.toUpperCase(), this.item);
            dB.echoApproval("New ItemStack created and saved as 'ITEMSTACK." + this.ID + "'");
        }
    }

    @EventHandler
    public void replaceableItemStacks(ReplaceableTagEvent e) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ObjectType {
        ITEMSTACK,
        ENTITY,
        NPC;

    }
}

