/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.npc.DenizenNPC;
import net.aufdemrand.denizen.scripts.ScriptEngine;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.entity.Player;

public class RandomCommand
extends AbstractCommand {
    Integer numberOfEntries;
    Player player;
    List<ScriptEntry> currentQueue = new ArrayList<ScriptEntry>();
    ScriptEngine.QueueType sendingQueue;
    DenizenNPC npc;

    public void onEnable() {
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        Integer numberOfEntries = null;
        this.sendingQueue = scriptEntry.getSendingQueue();
        this.npc = scriptEntry.getNPC();
        for (String arg : scriptEntry.getArguments()) {
            if (scriptEntry.getPlayer() != null) {
                this.player = scriptEntry.getPlayer();
            }
            if (this.aH.matchesInteger(arg)) {
                numberOfEntries = this.aH.getIntegerFrom(arg);
                dB.echoDebug("...will randomly select from the next %s entries.", arg);
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (numberOfEntries == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_LOCATION);
        }
        this.currentQueue = this.player != null ? this.denizen.getScriptEngine().getPlayerQueue(this.player, this.sendingQueue) : this.denizen.getScriptEngine().getDenizenQueue(this.npc, this.sendingQueue);
        if (this.currentQueue.size() < numberOfEntries) {
            throw new InvalidArgumentsException("Invalid Size! RANDOM [#] must not be larger than the script!");
        }
    }

    public void execute(String commandName) throws CommandExecutionException {
        Random random = new Random();
        int selected = random.nextInt(this.numberOfEntries);
        ScriptEntry sEtoKeep = null;
        dB.echoDebug("...random number generator selected '%s'", String.valueOf(selected + 1));
        for (int x = 0; x < this.numberOfEntries; ++x) {
            if (x != selected) {
                dB.echoDebug("...removing '%s'", this.currentQueue.get(0).getCommand());
                this.currentQueue.remove(0);
                continue;
            }
            dB.echoDebug("...selected '%s'", this.currentQueue.get(0).getCommand() + ": " + this.currentQueue.get(0).getArguments());
            sEtoKeep = this.currentQueue.get(0);
            this.currentQueue.remove(0);
        }
        this.currentQueue.add(0, sEtoKeep);
        if (this.player != null) {
            this.denizen.getScriptEngine().replaceQueue(this.player, this.currentQueue, this.sendingQueue);
        } else {
            this.denizen.getScriptEngine().replaceQueue(this.npc, this.currentQueue, this.sendingQueue);
        }
    }
}

