/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.triggers;

import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.interfaces.RegistrationableInstance;
import net.aufdemrand.denizen.npc.DenizenNPC;
import net.aufdemrand.denizen.scripts.ScriptBuilder;
import net.aufdemrand.denizen.scripts.helpers.ScriptHelper;
import net.aufdemrand.denizen.scripts.triggers.TriggerRegistry;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public abstract class AbstractTrigger
implements RegistrationableInstance {
    public Denizen denizen;
    protected ScriptHelper sH;
    protected ScriptBuilder sB;
    protected String name;
    public TriggerOptions triggerOptions = new TriggerOptions();

    public AbstractTrigger activate() {
        this.denizen = (Denizen)Bukkit.getPluginManager().getPlugin("Denizen");
        this.sH = this.denizen.getScriptEngine().getScriptHelper();
        this.sB = this.denizen.getScriptEngine().getScriptBuilder();
        return this;
    }

    public AbstractTrigger as(String triggerName) {
        this.name = triggerName.toUpperCase();
        this.denizen.getTriggerRegistry().register(triggerName, this);
        this.onEnable();
        return this;
    }

    public String getName() {
        return this.name;
    }

    public TriggerOptions getOptions() {
        return this.triggerOptions;
    }

    public void onDisable() {
    }

    public abstract boolean parse(DenizenNPC var1, Player var2, String var3);

    public AbstractTrigger withOptions(boolean enabledByDefault, double defaultCooldown, TriggerRegistry.CooldownType defaultCooldownType) {
        this.triggerOptions = new TriggerOptions(enabledByDefault, defaultCooldown, defaultCooldownType);
        return this;
    }

    public AbstractTrigger withOptions(boolean enabledByDefault, double defaultCooldown, int defaultRadius, TriggerRegistry.CooldownType defaultCooldownType) {
        this.triggerOptions = new TriggerOptions(enabledByDefault, defaultCooldown, defaultRadius, defaultCooldownType);
        return this;
    }

    public class TriggerOptions {
        public boolean ENABLED_BY_DEFAULT = true;
        public double DEFAULT_COOLDOWN = -1.0;
        public int DEFAULT_RADIUS = -1;
        public TriggerRegistry.CooldownType DEFAULT_COOLDOWN_TYPE = TriggerRegistry.CooldownType.NPC;

        public TriggerOptions() {
        }

        public TriggerOptions(boolean enabledByDefault, double defaultCooldown) {
            this.ENABLED_BY_DEFAULT = enabledByDefault;
            this.DEFAULT_COOLDOWN = defaultCooldown;
        }

        public TriggerOptions(boolean enabledByDefault, double defaultCooldown, TriggerRegistry.CooldownType defaultCooldownType) {
            this.ENABLED_BY_DEFAULT = enabledByDefault;
            this.DEFAULT_COOLDOWN = defaultCooldown;
            this.DEFAULT_COOLDOWN_TYPE = defaultCooldownType;
        }

        public TriggerOptions(boolean enabledByDefault, double defaultCooldown, int defaultRadius) {
            this.ENABLED_BY_DEFAULT = enabledByDefault;
            this.DEFAULT_COOLDOWN = defaultCooldown;
            this.DEFAULT_RADIUS = defaultRadius;
        }

        public TriggerOptions(boolean enabledByDefault, double defaultCooldown, int defaultRadius, TriggerRegistry.CooldownType defaultCooldownType) {
            this.ENABLED_BY_DEFAULT = enabledByDefault;
            this.DEFAULT_COOLDOWN = defaultCooldown;
            this.DEFAULT_RADIUS = defaultRadius;
            this.DEFAULT_COOLDOWN_TYPE = defaultCooldownType;
        }
    }
}

