/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.List;
import net.aufdemrand.denizen.events.ReplaceableTagEvent;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class BookCommand
extends AbstractCommand
implements Listener {
    BookAction action;
    Player player;
    String scriptName;
    ItemStack book;
    Location npcLocation;

    public void onEnable() {
        this.denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.denizen);
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        boolean newItem = false;
        this.action = BookAction.NONE;
        this.player = scriptEntry.getPlayer();
        this.scriptName = null;
        this.npcLocation = null;
        if (scriptEntry.getNPC() != null) {
            this.npcLocation = scriptEntry.getNPC().getLocation();
        }
        this.book = null;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesArg("DROP", arg) || aH.matchesArg("GIVE", arg) || aH.matchesArg("EQUIP", arg)) {
                this.action = BookAction.valueOf(arg.toUpperCase());
                continue;
            }
            if (aH.matchesScript(arg)) {
                this.scriptName = aH.getStringFrom(arg);
                dB.echoDebug("... script name set to '" + this.scriptName + "'.");
                continue;
            }
            if (aH.matchesItem(arg)) {
                this.book = aH.getItemFrom(arg);
                if (this.book.getType() == Material.BOOK || this.book.getType() == Material.WRITTEN_BOOK) {
                    dB.echoDebug("...using existing book '%s'.", arg);
                    newItem = true;
                    continue;
                }
                dB.echoError("This ItemStack is not a BOOK!");
                this.book = null;
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (this.action == BookAction.NONE && !newItem) {
            this.action = BookAction.GIVE;
        }
        if (this.scriptName == null) {
            throw new InvalidArgumentsException("Missing SCRIPT argument!");
        }
        if (this.book == null) {
            this.book = new ItemStack(387);
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        this.writeBook(this.book, this.scriptName);
        switch (this.action) {
            case DROP: {
                this.dropBook();
                break;
            }
            case GIVE: {
                this.giveBook(this.player);
                break;
            }
            case EQUIP: {
                this.equipBook(this.player);
                break;
            }
        }
        this.player.updateInventory();
    }

    private ItemStack writeBook(ItemStack book, String scriptName) {
        BookMeta bookInfo = (BookMeta)book.getItemMeta();
        String author = null;
        String title = null;
        List pages = null;
        if (scriptName == null) {
            return null;
        }
        if (this.denizen.getScripts().contains(scriptName.toUpperCase() + ".TYPE") && this.denizen.getScripts().getString(scriptName.toUpperCase() + ".TYPE").equalsIgnoreCase("BOOK")) {
            if (this.denizen.getScripts().getString(scriptName.toUpperCase() + ".TITLE") != null) {
                title = this.denizen.getScripts().getString(scriptName.toUpperCase() + ".TITLE");
                bookInfo.setTitle(title);
                dB.echoDebug("...book title set to '" + title + "'.");
            } else {
                dB.echoDebug("...no title specified.");
            }
            if (this.denizen.getScripts().getString(scriptName.toUpperCase() + ".AUTHOR") != null) {
                author = this.denizen.getScripts().getString(scriptName.toUpperCase() + ".AUTHOR");
                bookInfo.setAuthor(author);
                dB.echoDebug("...book author set to '" + author + "'.");
            } else {
                dB.echoDebug("...no author specified.");
            }
            if (this.denizen.getScripts().getString(scriptName.toUpperCase() + ".TEXT") != null) {
                pages = this.denizen.getScripts().getStringList(scriptName.toUpperCase() + ".TEXT");
                for (String thePage : pages) {
                    bookInfo.addPage(new String[]{thePage});
                    dB.echoDebug("...book page added.");
                }
            } else {
                dB.echoDebug("...no text specified.");
            }
            book.setItemMeta((ItemMeta)bookInfo);
            return book;
        }
        return null;
    }

    private void giveBook(Player player) {
        PlayerInventory inv = player.getInventory();
        int emptySpot = inv.firstEmpty();
        if (emptySpot != -1) {
            player.getInventory().addItem(new ItemStack[]{this.book});
            dB.echoDebug("... added book to player inventory");
        } else {
            player.getWorld().dropItem(player.getLocation(), this.book);
            dB.echoDebug("... player inventtory full, dropped book");
        }
    }

    public void equipBook(Player player) {
        ItemStack currItem = player.getItemInHand();
        PlayerInventory inv = player.getInventory();
        int emptySpot = inv.firstEmpty();
        if (currItem == null || currItem.getType() == Material.AIR) {
            player.setItemInHand(this.book);
            dB.echoDebug("... added book to player hand");
            return;
        }
        emptySpot = inv.firstEmpty();
        dB.echoDebug("emptySpot: " + emptySpot);
        if (emptySpot == -1) {
            player.getWorld().dropItem(player.getLocation(), this.book);
            dB.echoDebug("... dropped book, player inventory full");
        } else {
            inv.setItem(emptySpot, currItem);
            player.setItemInHand(this.book);
            dB.echoDebug("... added book to player hand, moved original item");
        }
    }

    public void dropBook() {
        this.player.getWorld().dropItem(this.npcLocation, this.book);
        dB.echoDebug("... dropped book by NPC");
    }

    @EventHandler
    public void paragraph(ReplaceableTagEvent e) {
        if (!e.matches("P")) {
            return;
        }
        e.setReplaceable("\n \u00a7r \n");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BookAction {
        GIVE,
        DROP,
        EQUIP,
        NONE;

    }
}

