/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.speech.SpeechContext;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class ChatCommand
extends AbstractCommand {
    public void onEnable() {
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        SpeechContext context = new SpeechContext("");
        if (scriptEntry.getNPC() != null) {
            context.setTalker(scriptEntry.getNPC().getEntity());
        }
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesValueArg("TARGET, TARGETS", arg, aH.ArgumentType.Custom)) {
                for (String target : aH.getListFrom(arg)) {
                    if (target.matches("\\d+")) {
                        NPC npc = CitizensAPI.getNPCRegistry().getById(Integer.valueOf(target).intValue());
                        if (npc != null) {
                            context.addRecipient(npc.getBukkitEntity());
                            continue;
                        }
                    } else {
                        Player player = Bukkit.getPlayer((String)target);
                        if (player != null) {
                            context.addRecipient((LivingEntity)player);
                            continue;
                        }
                    }
                    dB.echoError("Invalid TARGET '%s'!", target);
                }
                dB.echoDebug("Set TARGET(s).");
                continue;
            }
            if (aH.matchesValueArg("TALKER", arg, aH.ArgumentType.Custom)) {
                NPC npc;
                String talker = aH.getStringFrom(arg);
                if (talker.matches("\\d+") && (npc = CitizensAPI.getNPCRegistry().getById(Integer.valueOf(talker).intValue())) != null) {
                    dB.echoDebug("...set TALKER: '%s'", talker);
                    context.setTalker(npc.getBukkitEntity());
                    continue;
                }
                dB.echoError("Invalid TALKER! Perhaps the NPC doesn't exist?");
                continue;
            }
            context.setMessage(arg);
            dB.echoDebug(dB.Messages.DEBUG_SET_TEXT, arg);
        }
        if (context.getTalker() == null) {
            throw new InvalidArgumentsException("Must specify a valid TALKER.");
        }
        if (context.getMessage().length() < 1) {
            throw new InvalidArgumentsException("Must specify a message.");
        }
        scriptEntry.addObject("context", context);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        SpeechContext context = (SpeechContext)scriptEntry.getObject("context");
        if (CitizensAPI.getNPCRegistry().isNPC((Entity)context.getTalker().getEntity())) {
            CitizensAPI.getNPCRegistry().getNPC((Entity)context.getTalker().getEntity()).getDefaultSpeechController().speak(context, "chat");
        }
    }
}

