/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utilities {
    public boolean isEntity(String theString) {
        for (ValidEntities entity : ValidEntities.values()) {
            if (!entity.name().equals(theString.toUpperCase())) continue;
            return true;
        }
        return false;
    }

    public int lastIndexOfUCL(String str) {
        for (int i = str.length() - 1; i >= 0; --i) {
            if (!Character.isUpperCase(str.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOfLCL(String str) {
        for (int i = str.length() - 1; i >= 0; --i) {
            if (!Character.isLowerCase(str.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public String getVersionNumber() {
        Properties props = new Properties();
        props.put("version", "Unknown development build");
        try {
            props.load(this.getClass().getResourceAsStream("/META-INF/maven/net.aufdemrand/denizen/pom.properties"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return props.getProperty("version");
    }

    public String getVersionString() {
        return "Denizen version: " + this.getVersionNumber();
    }

    public Map<Material, Integer> getInventoryMap(Player thePlayer) {
        HashMap<Material, Integer> playerInv = new HashMap<Material, Integer>();
        ItemStack[] getContentsArray = thePlayer.getInventory().getContents();
        List<ItemStack> getContents = Arrays.asList(getContentsArray);
        for (int x = 0; x < getContents.size(); ++x) {
            if (getContents.get(x) == null) continue;
            if (playerInv.containsKey(getContents.get(x).getType())) {
                int t = (Integer)playerInv.get(getContents.get(x).getType());
                playerInv.put(getContents.get(x).getType(), t += getContents.get(x).getAmount());
                continue;
            }
            playerInv.put(getContents.get(x).getType(), getContents.get(x).getAmount());
        }
        return playerInv;
    }

    public Map<String, Integer> getInventoryIdMap(Player thePlayer) {
        HashMap<String, Integer> playerInv = new HashMap<String, Integer>();
        ItemStack[] getContentsArray = thePlayer.getInventory().getContents();
        List<ItemStack> getContents = Arrays.asList(getContentsArray);
        for (int x = 0; x < getContents.size(); ++x) {
            if (getContents.get(x) == null) continue;
            MaterialData specificItem = getContents.get(x).getData();
            String friendlyItem = specificItem.getItemTypeId() + ":" + specificItem.getData();
            if (playerInv.containsKey(friendlyItem)) {
                int t = (Integer)playerInv.get(friendlyItem);
                playerInv.put(friendlyItem, t += getContents.get(x).getAmount());
                continue;
            }
            playerInv.put(friendlyItem, getContents.get(x).getAmount());
        }
        return playerInv;
    }

    public static NPC getClosestNPC(Location location, int range) {
        NPC closestNPC = null;
        Double closestDistance = range;
        for (NPC npc : CitizensAPI.getNPCRegistry()) {
            if (!npc.isSpawned() || !npc.getBukkitEntity().getLocation().getWorld().equals(location.getWorld()) || !(npc.getBukkitEntity().getLocation().distance(location) < closestDistance)) continue;
            closestNPC = npc;
            closestDistance = npc.getBukkitEntity().getLocation().distance(location);
        }
        return closestNPC;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ValidEntities {
        BLAZE,
        BOAT,
        CAVE_SPIDER,
        CHICKEN,
        COW,
        CREEPER,
        ENDER_DRAGON,
        ENDERMAN,
        GHAST,
        GIANT,
        IRON_GOLEM,
        MAGMA_CUBE,
        MUSHROOM_COW,
        MINECART,
        OCELOT,
        PIG,
        PIG_ZOMBIE,
        PRIMED_TNT,
        SHEEP,
        SILVERFISH,
        SKELETON,
        SLIME,
        SNOWMAN,
        SQUID,
        VILLAGER,
        WOLF,
        ZOMBIE;

    }
}

