/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.List;
import net.aufdemrand.denizen.events.ReplaceableTagEvent;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class BookCommand
extends AbstractCommand
implements Listener {
    public void onEnable() {
        this.denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.denizen);
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        boolean newItem = false;
        BookAction action = BookAction.NONE;
        ItemStack book = null;
        Player player = scriptEntry.getPlayer();
        String scriptName = null;
        Location location = null;
        if (scriptEntry.getNPC() != null) {
            location = scriptEntry.getNPC().getLocation();
        }
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesArg("DROP, GIVE, EQUIP", arg)) {
                action = BookAction.valueOf(arg.toUpperCase());
                continue;
            }
            if (aH.matchesScript(arg)) {
                scriptName = aH.getStringFrom(arg);
                dB.echoDebug("...SCRIPT to use '" + scriptName + "'.");
                continue;
            }
            if (aH.matchesLocation(arg)) {
                location = aH.getLocationFrom(arg);
                action = BookAction.DROP;
                dB.echoDebug("...set DROP location: '%s'", aH.getStringFrom(arg));
                continue;
            }
            if (aH.matchesItem(arg)) {
                book = aH.getItemFrom(arg);
                if (book.getType() == Material.BOOK || book.getType() == Material.WRITTEN_BOOK) {
                    dB.echoDebug("...using existing book '%s'.", arg);
                    newItem = true;
                    continue;
                }
                dB.echoError("This ItemStack is not a BOOK!");
                book = null;
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (action == BookAction.NONE && !newItem) {
            action = BookAction.GIVE;
        }
        if (scriptName == null) {
            throw new InvalidArgumentsException("Missing SCRIPT argument!");
        }
        if (book == null) {
            book = new ItemStack(387);
        }
        scriptEntry.addObject("action", (Object)action);
        scriptEntry.addObject("book", book);
        scriptEntry.addObject("script", scriptName);
        scriptEntry.addObject("player", player);
        scriptEntry.addObject("location", location);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        BookAction action = (BookAction)((Object)scriptEntry.getObject("action"));
        ItemStack book = (ItemStack)scriptEntry.getObject("book");
        String scriptName = (String)scriptEntry.getObject("script");
        Player player = (Player)scriptEntry.getObject("player");
        Location location = (Location)scriptEntry.getObject("location");
        if (!this.writeBook(book, scriptName)) {
            throw new CommandExecutionException("Invalid BOOK script!");
        }
        switch (action) {
            case DROP: {
                this.dropBook(location, book);
                break;
            }
            case GIVE: {
                this.giveBook(player, book);
                break;
            }
            case EQUIP: {
                this.equipBook(player, book);
                break;
            }
        }
        player.updateInventory();
    }

    private boolean writeBook(ItemStack book, String scriptName) {
        BookMeta bookInfo = (BookMeta)book.getItemMeta();
        String author = null;
        String title = null;
        List pages = null;
        if (scriptName == null) {
            return false;
        }
        if (this.denizen.getScripts().contains(scriptName.toUpperCase() + ".TYPE") && this.denizen.getScripts().getString(scriptName.toUpperCase() + ".TYPE").equalsIgnoreCase("BOOK")) {
            if (this.denizen.getScripts().getString(scriptName.toUpperCase() + ".TITLE") != null) {
                title = this.denizen.getScripts().getString(scriptName.toUpperCase() + ".TITLE");
                bookInfo.setTitle(title);
                dB.echoDebug("...book title set to '" + title + "'.");
            } else {
                dB.echoDebug("...no title specified.");
            }
            if (this.denizen.getScripts().getString(scriptName.toUpperCase() + ".AUTHOR") != null) {
                author = this.denizen.getScripts().getString(scriptName.toUpperCase() + ".AUTHOR");
                bookInfo.setAuthor(author);
                dB.echoDebug("...book author set to '" + author + "'.");
            } else {
                dB.echoDebug("...no author specified.");
            }
            if (this.denizen.getScripts().getString(scriptName.toUpperCase() + ".TEXT") != null) {
                pages = this.denizen.getScripts().getStringList(scriptName.toUpperCase() + ".TEXT");
                for (String thePage : pages) {
                    bookInfo.addPage(new String[]{thePage});
                    dB.echoDebug("...book page added.");
                }
            } else {
                dB.echoDebug("...no text specified.");
            }
            book.setItemMeta((ItemMeta)bookInfo);
            return true;
        }
        return false;
    }

    private void giveBook(Player player, ItemStack book) {
        PlayerInventory inv = player.getInventory();
        int emptySpot = inv.firstEmpty();
        if (emptySpot != -1) {
            player.getInventory().addItem(new ItemStack[]{book});
            dB.echoDebug("... added book to player inventory");
        } else {
            player.getWorld().dropItem(player.getLocation(), book);
            dB.echoDebug("... player inventtory full, dropped book");
        }
    }

    private void equipBook(Player player, ItemStack book) {
        ItemStack currItem = player.getItemInHand();
        PlayerInventory inv = player.getInventory();
        int emptySpot = inv.firstEmpty();
        if (currItem == null || currItem.getType() == Material.AIR) {
            player.setItemInHand(book);
            dB.echoDebug("... added book to player hand");
            return;
        }
        emptySpot = inv.firstEmpty();
        dB.echoDebug("emptySpot: " + emptySpot);
        if (emptySpot == -1) {
            player.getWorld().dropItem(player.getLocation(), book);
            dB.echoDebug("... dropped book, player inventory full");
        } else {
            inv.setItem(emptySpot, currItem);
            player.setItemInHand(book);
            dB.echoDebug("... added book to player hand, moved original item");
        }
    }

    private void dropBook(Location location, ItemStack book) {
        location.getWorld().dropItem(location, book);
        dB.echoDebug("... dropped book by NPC");
    }

    @EventHandler
    public void paragraph(ReplaceableTagEvent e) {
        if (!e.matches("P")) {
            return;
        }
        e.setReplaceable("\n \u00a7r \n");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BookAction {
        GIVE,
        DROP,
        EQUIP,
        NONE;

    }
}

