/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.configuration.file.FileConfiguration;

public class CooldownCommand
extends AbstractCommand {
    String scriptName;
    int duration;
    String playerName;
    boolean global;
    private FileConfiguration sA = null;

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        this.scriptName = scriptEntry.getScript();
        this.duration = 0;
        this.playerName = null;
        this.global = false;
        if (scriptEntry.getPlayer() != null) {
            this.playerName = scriptEntry.getPlayer().getName();
        } else if (scriptEntry.getOfflinePlayer() != null) {
            this.playerName = scriptEntry.getOfflinePlayer().getName();
        }
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesDuration(arg) || aH.matchesInteger(arg)) {
                this.duration = aH.getIntegerFrom(arg);
                dB.echoDebug(dB.Messages.DEBUG_SET_DURATION, arg);
                continue;
            }
            if (aH.matchesArg("GLOBAL", arg)) {
                this.global = true;
                dB.echoDebug(dB.Messages.DEBUG_SET_GLOBAL, arg);
                continue;
            }
            if (aH.matchesScript(arg)) {
                this.scriptName = aH.getStringFrom(arg);
                dB.echoDebug(dB.Messages.DEBUG_SET_SCRIPT, this.scriptName);
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        if (this.playerName == null && !this.global) {
            throw new CommandExecutionException(dB.Messages.ERROR_NO_PLAYER);
        }
        this.setCooldown(this.playerName, this.duration, this.scriptName, this.global);
    }

    public boolean checkCooldown(String playerName, String scriptName) {
        playerName = playerName.toUpperCase();
        scriptName = scriptName.toUpperCase();
        if (this.sA == null) {
            this.sA = this.denizen.getScripts();
        }
        if (this.sA.contains("Global.Scripts." + scriptName + ".Cooldown Time")) {
            if (System.currentTimeMillis() < this.sA.getLong("Global.Scripts." + scriptName + ".Cooldown Time")) {
                return false;
            }
            this.sA.set("Global.Scripts." + scriptName + ".Cooldown Time", null);
        }
        if (!this.sA.contains("Players." + playerName + ".Scripts." + scriptName + ".Cooldown Time")) {
            return true;
        }
        if (System.currentTimeMillis() >= this.sA.getLong("Players." + playerName + ".Scripts." + scriptName + ".Cooldown Time")) {
            this.sA.set("Players." + playerName + ".Scripts." + scriptName + ".Cooldown Time", null);
            return true;
        }
        return false;
    }

    public void setCooldown(String playerName, int duration, String scriptName, boolean global) {
        playerName = playerName.toUpperCase();
        scriptName = scriptName.toUpperCase();
        if (global) {
            this.denizen.getSaves().set("Global.Scripts." + scriptName + ".Cooldown Time", (Object)(System.currentTimeMillis() + (long)(duration * 1000)));
            this.denizen.saveSaves();
        } else {
            this.denizen.getSaves().set("Players." + playerName + ".Scripts." + scriptName + ".Cooldown Time", (Object)(System.currentTimeMillis() + (long)(duration * 1000)));
            this.denizen.saveSaves();
        }
    }

    public void onEnable() {
    }
}

