/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.triggers.core;

import java.util.List;
import net.aufdemrand.denizen.npc.DenizenNPC;
import net.aufdemrand.denizen.npc.traits.TriggerTrait;
import net.aufdemrand.denizen.scripts.ScriptEngine;
import net.aufdemrand.denizen.scripts.triggers.AbstractTrigger;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;

public class ProximityTrigger
extends AbstractTrigger
implements Listener {
    public void onEnable() {
        this.denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.denizen);
    }

    public Integer getProximityRangeInBlocks() {
        return 3;
    }

    @EventHandler
    public void proximityTrigger(PlayerMoveEvent event) {
        if (!event.getTo().getBlock().equals(event.getFrom().getBlock())) {
            Location playerLocation = event.getTo();
            for (NPC npc : CitizensAPI.getNPCRegistry()) {
                if (!npc.hasTrait(TriggerTrait.class) || !((TriggerTrait)npc.getTrait(TriggerTrait.class)).isEnabled(this.name) || !((TriggerTrait)npc.getTrait(TriggerTrait.class)).trigger(this, event.getPlayer()) || !npc.isSpawned() || !npc.getBukkitEntity().getLocation().getWorld().equals(playerLocation.getWorld()) || npc.getBukkitEntity().getLocation().distance(playerLocation) > (double)this.getProximityRangeInBlocks().intValue() || npc.getBukkitEntity().getLocation().distance(event.getFrom()) <= (double)this.getProximityRangeInBlocks().intValue()) continue;
                dB.echoDebug(ChatColor.GOLD + " FOUND NPC IN RANGE: " + npc.getFullName());
                DenizenNPC denizenNPC = this.denizen.getNPCRegistry().getDenizen(npc);
                String theScript = denizenNPC.getInteractScript(event.getPlayer(), this.getClass());
                this.parse(denizenNPC, event.getPlayer(), theScript);
            }
        }
    }

    public boolean parse(DenizenNPC theDenizen, Player thePlayer, String theScriptName) {
        if (theScriptName == null) {
            return false;
        }
        String theStep = this.sH.getCurrentStep(thePlayer, theScriptName);
        String path = (theScriptName + ".Steps." + theStep + ".Proximity Trigger." + this.sH.scriptKey).toUpperCase();
        List<String> theScript = this.sH.getScriptContents(path);
        if (theScript == null || theScript.isEmpty()) {
            dB.echoDebug("    No script found for: " + path);
            return false;
        }
        this.sB.queueScriptEntries(thePlayer, this.sB.buildScriptEntries(thePlayer, theDenizen, theScript, theScriptName, theStep), ScriptEngine.QueueType.PLAYER);
        return true;
    }
}

