/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.aufdemrand.denizen.CommandHandler;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.events.ScriptsReloadEvent;
import net.aufdemrand.denizen.flags.FlagManager;
import net.aufdemrand.denizen.listeners.ListenerRegistry;
import net.aufdemrand.denizen.notables.NotableManager;
import net.aufdemrand.denizen.npc.DenizenNPCRegistry;
import net.aufdemrand.denizen.npc.activities.ActivityEngine;
import net.aufdemrand.denizen.npc.activities.ActivityRegistry;
import net.aufdemrand.denizen.npc.traits.AssignmentTrait;
import net.aufdemrand.denizen.npc.traits.ConstantsTrait;
import net.aufdemrand.denizen.npc.traits.HealthTrait;
import net.aufdemrand.denizen.npc.traits.NicknameTrait;
import net.aufdemrand.denizen.npc.traits.PushableTrait;
import net.aufdemrand.denizen.npc.traits.TriggerTrait;
import net.aufdemrand.denizen.scripts.ScriptEngine;
import net.aufdemrand.denizen.scripts.commands.CommandRegistry;
import net.aufdemrand.denizen.scripts.requirements.RequirementRegistry;
import net.aufdemrand.denizen.scripts.triggers.TriggerRegistry;
import net.aufdemrand.denizen.tags.TagManager;
import net.aufdemrand.denizen.utilities.Depends;
import net.aufdemrand.denizen.utilities.RuntimeCompiler;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.Citizens;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.trait.TraitInfo;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Denizen
extends JavaPlugin {
    public static String versionTag = "0.8.3 pre-release";
    private CommandHandler commandHandler;
    private ScriptEngine scriptEngine = new ScriptEngine(this);
    private ActivityEngine activityEngine = new ActivityEngine(this);
    private CommandRegistry commandRegistry = new CommandRegistry(this);
    private TriggerRegistry triggerRegistry = new TriggerRegistry(this);
    private RequirementRegistry requirementRegistry = new RequirementRegistry(this);
    private ActivityRegistry activityRegistry = new ActivityRegistry(this);
    private ListenerRegistry listenerRegistry = new ListenerRegistry(this);
    private DenizenNPCRegistry denizenNPCRegistry;
    private NotableManager notableManager = new NotableManager(this);
    private FlagManager flagManager = new FlagManager(this);
    private TagManager tagManager = new TagManager(this);
    public static Settings settings;
    public static Depends depends;
    private YamlConfiguration scriptConfig = null;
    private FileConfiguration savesConfig = null;
    private File savesConfigFile = null;
    private FileConfiguration assignmentConfig = null;
    private File assignmentConfigFile = null;

    public CommandHandler getCommandHandler() {
        return this.commandHandler;
    }

    public ActivityEngine getActivityEngine() {
        return this.activityEngine;
    }

    public ScriptEngine getScriptEngine() {
        return this.scriptEngine;
    }

    public ActivityRegistry getActivityRegistry() {
        return this.activityRegistry;
    }

    public CommandRegistry getCommandRegistry() {
        return this.commandRegistry;
    }

    public DenizenNPCRegistry getNPCRegistry() {
        return this.denizenNPCRegistry;
    }

    public ListenerRegistry getListenerRegistry() {
        return this.listenerRegistry;
    }

    public RequirementRegistry getRequirementRegistry() {
        return this.requirementRegistry;
    }

    public TriggerRegistry getTriggerRegistry() {
        return this.triggerRegistry;
    }

    public FlagManager flagManager() {
        return this.flagManager;
    }

    public TagManager tagManager() {
        return this.tagManager;
    }

    public NotableManager notableManager() {
        return this.notableManager;
    }

    public void onEnable() {
        dB.echoDebug(dB.DebugElement.Footer);
        dB.echoDebug(ChatColor.YELLOW + " _/_ _  ._  _ _  ");
        dB.echoDebug(ChatColor.YELLOW + "(/(-/ )/ /_(-/ ) " + ChatColor.GRAY + " scriptable NPCs");
        dB.echoDebug(dB.DebugElement.Spacer);
        dB.echoDebug(ChatColor.GRAY + "by: " + ChatColor.WHITE + "aufdemrand");
        dB.echoDebug(ChatColor.GRAY + "version: " + ChatColor.WHITE + versionTag);
        dB.echoDebug(dB.DebugElement.Footer);
        settings = new Settings();
        depends = new Depends();
        this.denizenNPCRegistry = new DenizenNPCRegistry(this);
        this.commandHandler = new CommandHandler(Depends.citizens);
        this.saveDefaultConfig();
        this.reloadConfig();
        this.reloadScripts();
        this.reloadSaves();
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(TriggerTrait.class).withName("triggers"));
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(PushableTrait.class).withName("pushable"));
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(AssignmentTrait.class).withName("assignment"));
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(NicknameTrait.class).withName("nickname"));
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(HealthTrait.class).withName("health"));
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(ConstantsTrait.class).withName("constants"));
        RuntimeCompiler compiler = new RuntimeCompiler(this);
        compiler.loader();
        this.getCommandRegistry().registerCoreMembers();
        this.getTriggerRegistry().registerCoreMembers();
        this.getActivityRegistry().registerCoreMembers();
        this.getRequirementRegistry().registerCoreMembers();
        this.getListenerRegistry().registerCoreMembers();
        this.notableManager().loadNotables();
        this.tagManager().registerCoreTags();
        Depends.citizens.registerCommandClass(CommandHandler.class);
        this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, new Runnable(){

            public void run() {
                Denizen.this.getScriptEngine().run();
            }
        }, (long)settings.InteractDelayInTicks(), (long)settings.InteractDelayInTicks());
        this.getServer().getPluginManager().registerEvents((Listener)this.getActivityEngine(), (Plugin)this);
        this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, new Runnable(){

            public void run() {
                Denizen.this.getActivityEngine().scheduler(false);
            }
        }, 1L, 600L);
        dB.echoDebug(dB.DebugElement.Footer);
    }

    public void onDisable() {
        this.getLogger().log(Level.INFO, " v" + this.getDescription().getVersion() + " disabled.");
        Bukkit.getServer().getScheduler().cancelTasks((Plugin)this);
        HandlerList.unregisterAll((Plugin)this);
        this.saveSaves();
    }

    public void reloadScripts() {
        String concatenated = this.scriptEngine.getScriptHelper().concatenateScripts();
        if (this.scriptConfig == null) {
            this.scriptConfig = new YamlConfiguration();
        }
        try {
            this.scriptConfig.loadFromString(concatenated);
            Bukkit.getServer().getPluginManager().callEvent((Event)new ScriptsReloadEvent());
        }
        catch (InvalidConfigurationException e) {
            this.getLogger().log(Level.SEVERE, "Error loading scripts to memory!");
            e.printStackTrace();
        }
    }

    public FileConfiguration getScripts() {
        if (this.scriptConfig == null) {
            this.reloadScripts();
        }
        return this.scriptConfig;
    }

    public void reloadSaves() {
        if (this.savesConfigFile == null) {
            this.savesConfigFile = new File(this.getDataFolder(), "saves.yml");
        }
        this.savesConfig = YamlConfiguration.loadConfiguration((File)this.savesConfigFile);
    }

    public FileConfiguration getSaves() {
        if (this.savesConfig == null) {
            this.reloadSaves();
        }
        return this.savesConfig;
    }

    public void saveSaves() {
        if (this.savesConfig == null || this.savesConfigFile == null) {
            return;
        }
        try {
            this.savesConfig.save(this.savesConfigFile);
        }
        catch (IOException ex) {
            Logger.getLogger(JavaPlugin.class.getName()).log(Level.SEVERE, "Could not save config to " + this.savesConfigFile, ex);
        }
    }

    public void reloadAssignments() {
        if (this.assignmentConfigFile == null) {
            this.assignmentConfigFile = new File(this.getDataFolder(), "assignments.yml");
        }
        this.assignmentConfig = YamlConfiguration.loadConfiguration((File)this.assignmentConfigFile);
        InputStream defConfigStream = this.getResource("assignments.yml");
        if (defConfigStream != null) {
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((InputStream)defConfigStream);
            this.assignmentConfig.setDefaults((Configuration)defConfig);
        }
    }

    public FileConfiguration getAssignments() {
        if (this.assignmentConfig == null) {
            this.reloadAssignments();
        }
        return this.assignmentConfig;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String cmdName, String[] args) {
        Citizens citizens = (Citizens)this.getServer().getPluginManager().getPlugin("Citizens");
        return citizens.onCommand(sender, cmd, cmdName, args);
    }
}

