/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.notables;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.notables.Notable;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Bukkit;
import org.bukkit.Location;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotableManager {
    Denizen denizen;
    private Map<String, Notable> notableMap = new ConcurrentHashMap<String, Notable>();

    public NotableManager() {
    }

    public NotableManager(Denizen denizen) {
        this.denizen = denizen;
    }

    public boolean addNotable(String name, Location location) {
        this.notableMap.put(name, new Notable(name, location));
        this.saveNotables();
        return true;
    }

    public Notable getNotable(String name) {
        return this.notableMap.get(name);
    }

    public Collection<Notable> getNotables() {
        return this.notableMap.values();
    }

    public void loadNotables() {
        List notablesList = this.denizen.getSaves().getStringList("Notables.List");
        if (notablesList.isEmpty()) {
            return;
        }
        this.notableMap.clear();
        for (String notable : notablesList) {
            String[] ns = notable.split(";");
            try {
                this.notableMap.put(ns[0], new Notable(ns[0], new Location(Bukkit.getServer().getWorld(ns[1]), Double.valueOf(ns[2]).doubleValue(), Double.valueOf(ns[3]).doubleValue(), Double.valueOf(ns[4]).doubleValue())));
            }
            catch (NumberFormatException nfe) {
                dB.echoError("NumberFormatException loading notable: " + notable);
            }
        }
    }

    public Notable removeNotable(Notable notable) {
        return this.notableMap.remove(notable.getName());
    }

    public Notable removeNotable(String notableName) {
        return this.notableMap.remove(notableName);
    }

    public void saveNotables() {
        ArrayList<String> notablesList = new ArrayList<String>();
        for (Notable notable : this.notableMap.values()) {
            notablesList.add(notable.stringValue());
        }
        this.denizen.getSaves().set("Notables.List", notablesList);
    }
}

