/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.npc.activities;

import java.util.List;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.npc.DenizenNPC;
import net.aufdemrand.denizen.npc.traits.TriggerTrait;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.runnables.Runnable1;
import net.citizensnpcs.api.event.NPCSpawnEvent;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ActivityEngine
implements Listener {
    Denizen denizen;

    public ActivityEngine(Denizen denizen) {
        this.denizen = denizen;
    }

    @EventHandler
    public void setDefaultActivity(NPCSpawnEvent event) {
        if (event.getNPC().hasTrait(TriggerTrait.class)) {
            this.denizen.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.denizen, (Runnable)new Runnable1<NPC>(event.getNPC()){

                @Override
                public void run(NPC theNPC) {
                    block2: {
                        try {
                            ActivityEngine.this.setDefaultActivity(ActivityEngine.this.denizen.getNPCRegistry().getDenizen(theNPC));
                        }
                        catch (Exception e) {
                            if (!dB.showStackTraces) break block2;
                            e.printStackTrace();
                        }
                    }
                }
            }, 30L);
        }
    }

    public void setDefaultActivity(DenizenNPC theDenizen) {
        if (this.denizen.getAssignments().contains("Denizens." + theDenizen.getName() + ".Default Activity")) {
            this.setActivityScript(theDenizen, this.denizen.getAssignments().getString("Denizens." + theDenizen.getName() + ".Default Activity"));
        }
    }

    public void scheduler(boolean forceable) {
        if (this.denizen.getNPCRegistry().getDenizens().isEmpty()) {
            return;
        }
        for (DenizenNPC theDenizen : this.denizen.getNPCRegistry().getDenizens().values()) {
            if (!theDenizen.isSpawned()) continue;
            if (forceable) {
                this.denizen.getSaves().set("Denizens." + theDenizen.getName() + "." + theDenizen.getId() + ".Active Activity Script", null);
                this.denizen.getActivityRegistry().removeAllActivities(theDenizen.getCitizen());
                this.setDefaultActivity(theDenizen);
                continue;
            }
            int denizenTime = Math.round(theDenizen.getWorld().getTime() / 1000L);
            List denizenActivities = this.denizen.getAssignments().getStringList("Denizens." + theDenizen.getName() + ".Scheduled Activities");
            if (denizenActivities.isEmpty()) continue;
            for (String activity : denizenActivities) {
                if (!activity.startsWith(String.valueOf(denizenTime))) continue;
                String activityScript = activity.split(" ", 2)[1];
                if (!this.denizen.getSaves().contains("Denizens." + theDenizen.getName() + "." + theDenizen.getId() + ".Active Activity Script")) {
                    this.setActivityScript(theDenizen, activityScript);
                    continue;
                }
                if (this.denizen.getSaves().getString("Denizens." + theDenizen.getName() + "." + theDenizen.getId() + ".Active Activity Script").toUpperCase().equals(activityScript.toUpperCase())) continue;
                this.setActivityScript(theDenizen, activityScript);
            }
        }
    }

    public void setActivityScript(DenizenNPC denizenNPC, String scriptName) {
        dB.echoDebug(dB.DebugElement.Header, "Updating activity: " + denizenNPC.getName() + "/" + denizenNPC.getId());
        this.denizen.getSaves().set("Denizens." + denizenNPC.getName() + "." + denizenNPC.getId() + ".Active Activity Script", (Object)scriptName);
        if (!this.denizen.getScripts().contains(scriptName + ".Activities.List")) {
            dB.echoError("Tried to load the Activity Script '" + scriptName + ".Activities.List', but it couldn't be found. Perhaps something is spelled wrong, or the script doesn't exist?");
            return;
        }
        this.denizen.getActivityRegistry().removeAllActivities(denizenNPC.getCitizen());
        for (String activity : this.denizen.getScripts().getStringList(scriptName + ".Activities.List")) {
            String[] arguments = this.denizen.getScriptEngine().getScriptBuilder().buildArgs(activity.split(" ", 3)[2]);
            int priority = Integer.parseInt(activity.split(" ", 3)[0]);
            activity = activity.split(" ", 3)[1];
            this.denizen.getActivityRegistry().addActivity(activity, denizenNPC, arguments, priority);
        }
        dB.echoDebug(dB.DebugElement.Footer);
    }
}

