/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.npc.traits;

import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.notables.Notable;
import net.aufdemrand.denizen.npc.traits.ConstantsTrait;
import net.aufdemrand.denizen.npc.traits.TriggerTrait;
import net.aufdemrand.denizen.scripts.ScriptHelper;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.command.exception.CommandException;
import net.citizensnpcs.util.Paginator;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AssignmentTrait
extends Trait {
    private Denizen denizen = (Denizen)Bukkit.getServer().getPluginManager().getPlugin("Denizen");
    private String assignment = "";

    public AssignmentTrait() {
        super("assignment");
    }

    public void buildLocationContext() {
    }

    public void load(DataKey key) throws NPCLoadException {
        this.assignment = key.getString("assignment");
        if (this.hasAssignment() && !this.checkAssignment(this.assignment)) {
            dB.echoError("Missing assignment '" + this.assignment + "' for NPC '" + this.npc.getName() + "/" + this.npc.getId() + "! Perhaps the script has been removed?");
        }
    }

    public void save(DataKey key) {
        key.setString("assignment", this.assignment);
    }

    public boolean hasAssignment() {
        return !this.assignment.equals("");
    }

    public String getAssignment() {
        return this.assignment;
    }

    public void removeAssignment(Player player) {
        this.assignment = "";
        this.denizen.getNPCRegistry().getDenizen(this.npc).action("remove assignment", player);
    }

    public void removeAssignment() {
        this.removeAssignment(null);
    }

    public boolean checkAssignment(String assignment) {
        return this.denizen.getScriptEngine().getScriptHelper().getStringIgnoreCase(assignment + ".TYPE", "") != null && this.denizen.getScriptEngine().getScriptHelper().getStringIgnoreCase(assignment + ".TYPE", "").equalsIgnoreCase("ASSIGNMENT");
    }

    public boolean setAssignment(String assignment) {
        return this.setAssignment(assignment, null);
    }

    public boolean setAssignment(String assignment, Player player) {
        if (this.checkAssignment(assignment)) {
            this.assignment = assignment.toUpperCase();
            if (!this.npc.hasTrait(ConstantsTrait.class)) {
                this.npc.addTrait(ConstantsTrait.class);
            }
            if (!this.npc.hasTrait(TriggerTrait.class)) {
                this.npc.addTrait(TriggerTrait.class);
            }
            this.denizen.getNPCRegistry().getDenizen(this.npc).action("assignment", player);
            return true;
        }
        return false;
    }

    public void describe(CommandSender sender, int page) throws CommandException {
        ScriptHelper sH = this.denizen.getScriptEngine().getScriptHelper();
        Paginator paginator = new Paginator().header("Assignment");
        paginator.addLine("<e>Current assignment: " + (this.hasAssignment() ? this.assignment : "None.") + "");
        paginator.addLine("");
        if (!this.hasAssignment()) {
            paginator.sendPage(sender, page);
            return;
        }
        boolean entriesPresent = false;
        paginator.addLine(ChatColor.GRAY + "Interact Scripts:");
        paginator.addLine("<e>Key: <a>Priority  <b>Name");
        if (!sH.getStringListIgnoreCase(this.assignment + ".INTERACT SCRIPTS").isEmpty()) {
            entriesPresent = true;
            for (String scriptEntry : sH.getStringListIgnoreCase(this.assignment + ".INTERACT SCRIPTS")) {
                paginator.addLine("<a>" + scriptEntry.split(" ")[0] + "<b> " + scriptEntry.split(" ", 2)[1]);
            }
        }
        if (!entriesPresent) {
            paginator.addLine("<c>No Interact Scripts assigned.");
        }
        paginator.addLine("");
        if (!entriesPresent) {
            if (!paginator.sendPage(sender, page)) {
                throw new CommandException("citizens.commands.page-missing");
            }
            return;
        }
        entriesPresent = false;
        paginator.addLine(ChatColor.GRAY + "Scheduled Scripts:");
        paginator.addLine("<e>Key: <a>Time  <b>Name");
        if (!sH.getStringListIgnoreCase(this.assignment + ".SCHEDULED ACTIVITIES").isEmpty()) {
            entriesPresent = true;
            for (String scriptEntry : sH.getStringListIgnoreCase(this.assignment + ".SCHEDULED ACTIVITIES")) {
                paginator.addLine("<a>" + scriptEntry.split(" ")[0] + "<b> " + scriptEntry.split(" ", 2)[1]);
            }
        }
        if (!entriesPresent) {
            paginator.addLine("<c>No scheduled scripts activities.");
        }
        paginator.addLine("");
        entriesPresent = false;
        paginator.addLine(ChatColor.GRAY + "Linked Notable Locations:");
        paginator.addLine("<e>Key: <a>Name  <b>World  <c>Location");
        if (!this.denizen.notableManager().getNotables().isEmpty()) {
            entriesPresent = true;
        }
        for (Notable notable : this.denizen.notableManager().getNotables()) {
            if (!notable.hasLink(this.npc.getId())) continue;
            paginator.addLine(notable.describe());
        }
        if (!entriesPresent) {
            paginator.addLine("<c>No notable locations linked to this NPC.");
        }
        paginator.addLine("");
        entriesPresent = false;
        paginator.addLine(ChatColor.GRAY + "Actions:");
        paginator.addLine("<e>Key: <a>Action name  <b>Script Size");
        if (this.denizen.getScripts().contains(this.assignment.toUpperCase() + ".Actions")) {
            entriesPresent = true;
        }
        if (entriesPresent) {
            for (String action : this.denizen.getScripts().getConfigurationSection(this.assignment.toUpperCase() + ".ACTIONS").getKeys(false)) {
                paginator.addLine("<a>" + action + " <b>" + sH.getStringListIgnoreCase(this.assignment + ".ACTIONS." + action).size());
            }
        } else {
            paginator.addLine("<c>No actions defined in the assignment.");
        }
        paginator.addLine("");
        if (!paginator.sendPage(sender, page)) {
            throw new CommandException("citizens.commands.page-missing", new Object[]{page});
        }
    }
}

