/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.npc.traits;

import net.citizensnpcs.api.ai.event.NavigationBeginEvent;
import net.citizensnpcs.api.ai.event.NavigationCancelEvent;
import net.citizensnpcs.api.ai.event.NavigationCompleteEvent;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;
import org.bukkit.Location;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class HungerTrait
extends Trait
implements Listener {
    double maxHunger = 20.0;
    double currentHunger = 0.0;
    int multiplier = 1;
    boolean listening = false;
    Location location = null;
    private int count = 0;

    public HungerTrait() {
        super("hunger");
    }

    public void load(DataKey key) throws NPCLoadException {
        this.maxHunger = key.getDouble("maxhunger", 20.0);
        this.currentHunger = key.getDouble("currenthunger", 0.0);
        this.multiplier = key.getInt("multiplier", 1);
    }

    public void save(DataKey key) {
        key.setDouble("maxhealth", this.maxHunger);
        key.setDouble("currenthealth", this.currentHunger);
    }

    public void run() {
        if (!this.listening) {
            return;
        }
        ++this.count;
        if (this.count >= 20) {
            this.count = 0;
            double td = this.getDistance(this.npc.getBukkitEntity().getLocation());
            if (td > 0.0) {
                this.location = this.npc.getBukkitEntity().getLocation().clone();
                this.currentHunger -= td * 0.01 * (double)this.multiplier;
            }
        }
    }

    @EventHandler
    public void onMove(NavigationBeginEvent event) {
        this.location = this.npc.getBukkitEntity().getLocation().clone();
        this.listening = true;
    }

    @EventHandler
    public void onCancel(NavigationCancelEvent event) {
        this.listening = false;
    }

    @EventHandler
    public void onCancel(NavigationCompleteEvent event) {
        this.listening = false;
    }

    public double getDistance(Location location) {
        if (!this.npc.getBukkitEntity().getWorld().equals(location.getWorld())) {
            this.location = this.npc.getBukkitEntity().getLocation();
            return 0.0;
        }
        return location.distance(this.location);
    }

    public double getHunger() {
        return this.currentHunger;
    }

    public double getMaxHunger() {
        return this.maxHunger;
    }

    public int getHungerPercentage() {
        return (int)((double)((int)this.currentHunger) / this.maxHunger);
    }

    public int getHungerMultiplier() {
        return this.multiplier;
    }

    public void setHungerMultiplier(int multiplier) {
        this.multiplier = multiplier;
    }

    public void setHunger(double hunger) {
        this.currentHunger = hunger;
    }

    public void feed(double hunger) {
        this.currentHunger -= hunger;
        if (this.currentHunger < 0.0) {
            this.currentHunger = 0.0;
        }
    }

    public void setMaxHunger(double hunger) {
        this.maxHunger = hunger;
    }

    public boolean isStarving() {
        return this.currentHunger >= this.maxHunger;
    }

    public boolean isHungry() {
        return this.currentHunger > this.maxHunger / 10.0;
    }
}

