/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.flags.FlagManager;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.event.Listener;

public class FlagCommand
extends AbstractCommand
implements Listener {
    private String flagName;
    private String flagValue;
    private String playerName;
    private FlagManager.Flag flag;
    private int npcId;
    private int index;
    private int duration;
    FlagAction flagAction;
    FlagType flagType;

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        this.flagName = null;
        this.flagValue = null;
        this.playerName = null;
        this.flag = null;
        this.npcId = -1;
        this.index = -1;
        this.duration = -1;
        this.flagAction = null;
        this.flagType = FlagType.PLAYER;
        if (scriptEntry.getNPC() != null) {
            this.npcId = scriptEntry.getNPC().getId();
        }
        if (scriptEntry.getPlayer() != null) {
            this.playerName = scriptEntry.getPlayer().getName();
        } else if (scriptEntry.getOfflinePlayer() != null) {
            this.playerName = scriptEntry.getOfflinePlayer().getName();
        }
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesDuration(arg)) {
                this.duration = aH.getIntegerFrom(arg);
                dB.echoDebug("...flag will expire after '%s' seconds.", arg);
                continue;
            }
            if (aH.matchesArg("GLOBAL", arg) || aH.matchesArg("DENIZEN", arg) || aH.matchesArg("PLAYER", arg)) {
                this.flagType = FlagType.valueOf(arg.toUpperCase());
                dB.echoDebug(dB.Messages.DEBUG_SET_FLAG_TYPE, this.flagType.name());
                continue;
            }
            if (arg.split(":", 3).length > 1) {
                String[] flagArgs = arg.split(":");
                this.flagName = flagArgs[0].toUpperCase();
                if (flagArgs.length == 2) {
                    if (flagArgs[1].contains("+")) {
                        this.flagAction = FlagAction.INCREASE;
                        this.flagValue = "1";
                    } else if (flagArgs[1].contains("-")) {
                        this.flagAction = FlagAction.DECREASE;
                        this.flagValue = "1";
                    } else {
                        this.flagAction = FlagAction.SET_VALUE;
                        this.flagValue = arg.split(":")[1];
                    }
                } else if (flagArgs.length == 3) {
                    if (flagArgs[1].contains("->")) {
                        this.flagAction = FlagAction.INSERT;
                    } else if (flagArgs[1].contains("<-")) {
                        this.flagAction = FlagAction.REMOVE;
                    } else if (flagArgs[1].contains("+")) {
                        this.flagAction = FlagAction.INCREASE;
                    } else if (flagArgs[1].contains("-")) {
                        this.flagAction = FlagAction.DECREASE;
                    } else if (flagArgs[1].contains("*")) {
                        this.flagAction = FlagAction.MULTIPLY;
                    } else if (flagArgs[1].contains("/")) {
                        this.flagAction = FlagAction.DIVIDE;
                    }
                    this.flagValue = flagArgs[2];
                }
                dB.echoDebug(dB.Messages.DEBUG_SET_FLAG_ACTION, arg);
                continue;
            }
            this.flagName = arg.toUpperCase();
            this.flagAction = FlagAction.SET_BOOLEAN;
            dB.echoDebug("...setting '%s' as boolean flag.", arg.toUpperCase());
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        if (this.flagName.split("\\[").length > 1) {
            try {
                this.index = Integer.valueOf(this.flagName.split("\\[")[1].replace("]", ""));
            }
            catch (Exception e) {
                this.index = -1;
            }
            dB.echoDebug("...flag list index set to '" + this.index + "'.");
            this.flagName = this.flagName.split("\\[")[0];
        }
        this.flag = this.flagType.equals((Object)FlagType.NPC) ? this.denizen.flagManager().getNPCFlag(this.npcId, this.flagName) : (this.flagType.equals((Object)FlagType.PLAYER) ? this.denizen.flagManager().getPlayerFlag(this.playerName, this.flagName) : this.denizen.flagManager().getGlobalFlag(this.flagName));
        switch (this.flagAction) {
            case INCREASE: 
            case DECREASE: 
            case MULTIPLY: 
            case DIVIDE: {
                double currentValue = this.flag.get(this.index).asDouble();
                this.flag.set(this.math(currentValue, Double.valueOf(this.flagValue), this.flagAction), this.index);
                break;
            }
            case SET_BOOLEAN: {
                this.flag.set(true, this.index);
                break;
            }
            case SET_VALUE: {
                this.flag.set(this.flagValue, this.index);
                break;
            }
            case INSERT: {
                this.flag.add(this.flagValue);
                break;
            }
            case REMOVE: {
                this.flag.remove(this.flagValue, this.index);
            }
        }
        if (this.duration > 0) {
            this.flag.setExpiration(System.currentTimeMillis() + (long)(this.duration * 1000));
        }
    }

    private double math(double currentValue, double value, FlagAction flagAction) {
        switch (flagAction) {
            case INCREASE: {
                return currentValue + value;
            }
            case DECREASE: {
                return currentValue - value;
            }
            case MULTIPLY: {
                return currentValue * value;
            }
            case DIVIDE: {
                return currentValue / value;
            }
        }
        return 0.0;
    }

    public void onEnable() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FlagType {
        GLOBAL,
        NPC,
        PLAYER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FlagAction {
        SET_VALUE,
        SET_BOOLEAN,
        INCREASE,
        DECREASE,
        MULTIPLY,
        DIVIDE,
        INSERT,
        REMOVE;

    }
}

