/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.triggers.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.npc.DenizenNPC;
import net.aufdemrand.denizen.npc.traits.TriggerTrait;
import net.aufdemrand.denizen.scripts.ScriptEngine;
import net.aufdemrand.denizen.scripts.ScriptHelper;
import net.aufdemrand.denizen.scripts.triggers.AbstractTrigger;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChatTrigger
extends AbstractTrigger
implements Listener {
    private String playerMessage;

    @Override
    public void onEnable() {
        this.denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.denizen);
    }

    private Boolean ChatGloballyIfFailedChatTriggers() {
        return true;
    }

    private Boolean chatGloballyIfNotInteractable() {
        return true;
    }

    private Boolean chatGloballyIfNoChatTriggers() {
        return true;
    }

    private Boolean isInteractable(DenizenNPC npc, Player player) {
        return true;
    }

    private Boolean isKeywordRegex(String keyWord) {
        return keyWord.toUpperCase().startsWith("REGEX:");
    }

    @EventHandler
    public void chatTrigger(AsyncPlayerChatEvent event) {
        NPC closestNPC = Utilities.getClosestNPC(event.getPlayer().getLocation(), 3);
        if (closestNPC == null) {
            return;
        }
        dB.echoDebug("  Closest NPC: " + closestNPC.getFullName());
        if (!closestNPC.hasTrait(TriggerTrait.class)) {
            dB.echoDebug("  NPC does not have the trigger trait: " + TriggerTrait.class);
            return;
        }
        if (!((TriggerTrait)closestNPC.getTrait(TriggerTrait.class)).isEnabled(this.name)) {
            dB.echoDebug("  Trigger " + this.name + " is not enabled.");
            return;
        }
        if (!((TriggerTrait)closestNPC.getTrait(TriggerTrait.class)).trigger(this, event.getPlayer())) {
            dB.echoDebug("  The NPC is currently unavailable.");
            return;
        }
        DenizenNPC denizenNPC = this.denizen.getNPCRegistry().getDenizen(closestNPC);
        dB.echoDebug("Found nearby NPC, interrupting chat...", this.name);
        if (!this.isInteractable(denizenNPC, event.getPlayer()).booleanValue()) {
            if (!this.chatGloballyIfNotInteractable().booleanValue()) {
                event.setCancelled(true);
                return;
            }
            dB.echoDebug("Not interactable, resuming chat...", this.name);
            return;
        }
        String theScript = denizenNPC.getInteractScript(event.getPlayer(), this.getClass());
        this.playerMessage = event.getMessage();
        if (this.parse(denizenNPC, event.getPlayer(), theScript)) {
            event.setCancelled(true);
            return;
        }
        dB.echoDebug(ChatColor.LIGHT_PURPLE + "| " + ChatColor.YELLOW + "INFO! " + ChatColor.WHITE + "No matching chat trigger.");
        dB.echoDebug(ChatColor.LIGHT_PURPLE + "+---------------------+");
        if (!this.ChatGloballyIfFailedChatTriggers().booleanValue()) {
            event.setCancelled(true);
            return;
        }
        dB.echoDebug("No matching triggers in script, resuming chat...", this.name);
    }

    @Override
    public boolean parse(DenizenNPC theDenizen, Player thePlayer, String theScriptName) {
        Boolean foundTrigger = false;
        ScriptEngine sE = this.denizen.getScriptEngine();
        ScriptHelper sH = sE.getScriptHelper();
        dB.echoDebug(ChatColor.LIGHT_PURPLE + "+- Parsing chat trigger: " + theDenizen.getName() + "/" + thePlayer.getName() + " -+");
        dB.echoDebug(ChatColor.LIGHT_PURPLE + "| " + ChatColor.WHITE + "Getting current step:");
        dB.echoDebug(ChatColor.LIGHT_PURPLE + "| Script Name:" + ChatColor.WHITE + theScriptName);
        String theStep = sH.getCurrentStep(thePlayer, theScriptName);
        Map<String, List<String>> triggerMap = this.getChatTriggers(theScriptName, theStep);
        for (String triggerStep : triggerMap.keySet()) {
            dB.echoDebug("Checking step: " + triggerStep);
            Boolean foundMatch = true;
            for (String keyWord : triggerMap.get(triggerStep)) {
                dB.echoDebug(ChatColor.LIGHT_PURPLE + "Checking: " + keyWord);
                if (this.isKeywordRegex(keyWord).booleanValue()) {
                    dB.echoDebug("REGEX");
                    Pattern pattern = Pattern.compile(keyWord.substring(6));
                    if (pattern.matcher(this.playerMessage).find()) continue;
                    dB.echoDebug(ChatColor.GOLD + "  " + this.playerMessage + " does not match regex: " + keyWord.substring(6) + ".");
                    foundMatch = false;
                    break;
                }
                if (this.playerMessage.toLowerCase().contains(keyWord.toLowerCase())) continue;
                dB.echoDebug(ChatColor.GOLD + "  \"" + this.playerMessage + "\" does not match.");
                foundMatch = false;
                break;
            }
            if (!foundMatch.booleanValue()) continue;
            dB.echoDebug(ChatColor.GREEN + "  found match.");
            foundTrigger = true;
            ScriptHelper scriptHelper = sE.getScriptHelper();
            StringBuilder stringBuilder = new StringBuilder().append(triggerStep);
            sE.getScriptHelper();
            List<String> theScript = scriptHelper.getScriptContents(stringBuilder.append(ScriptHelper.scriptKey).toString());
            if (theScript == null || theScript.isEmpty()) {
                StringBuilder stringBuilder2 = new StringBuilder().append("    No script found for: ").append(triggerStep);
                sE.getScriptHelper();
                dB.echoDebug(stringBuilder2.append(ScriptHelper.scriptKey).toString());
                continue;
            }
            this.sB.queueScriptEntries(thePlayer, this.sB.buildScriptEntries(thePlayer, theDenizen, theScript, theScriptName, theStep), ScriptEngine.QueueType.PLAYER);
        }
        return foundTrigger;
    }

    public Map<String, List<String>> getChatTriggers(String theScript, String currentStep) {
        Pattern triggerPattern = Pattern.compile("\\/([^/]*)\\/");
        String path = (theScript + ".Steps." + currentStep + ".Chat Trigger").toUpperCase();
        HashMap<String, List<String>> triggerMap = new HashMap<String, List<String>>();
        for (String key : this.denizen.getScripts().getConfigurationSection(path).getKeys(false)) {
            String stepKey = (path + "." + key + ".Trigger").toUpperCase();
            String triggerValue = this.denizen.getScripts().getString(stepKey);
            dB.echoDebug("stepKey: " + stepKey);
            dB.echoDebug("  triggerValue: " + triggerValue);
            if (triggerValue == null || !triggerValue.contains("/")) continue;
            ArrayList<String> keyWords = new ArrayList<String>();
            Matcher matcher = triggerPattern.matcher(triggerValue);
            while (matcher.find()) {
                String keyWord = matcher.group();
                keyWords.add(keyWord.substring(1, keyWord.length() - 1));
            }
            triggerMap.put(path + "." + key, keyWords);
        }
        return triggerMap;
    }
}

