/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events;

import net.aufdemrand.denizen.npc.DenizenNPC;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

public class ReplaceableTagEvent
extends Event {
    private static final HandlerList handlers = new HandlerList();
    private Player player;
    private DenizenNPC npc;
    private boolean instant = false;
    private boolean replaced = false;
    private String name;
    private String replaceable;
    private String value = null;
    private String type = null;
    private String index = null;
    private String fallback = null;

    public ReplaceableTagEvent(Player player, DenizenNPC npc, String tag) {
        if (tag.split("\\(").length > 1) {
            this.fallback = tag.split("\\(", 2)[1];
            tag = tag.split("\\(", 2)[0];
        }
        this.player = player;
        this.npc = npc;
        this.name = tag.split(":", 2)[0];
        if (this.name.contains(".")) {
            this.type = this.name.split("\\.", 2)[1];
            this.name = this.name.split("\\.", 2)[0];
        }
        if (tag.split(":").length > 1) {
            this.value = tag.split(":", 2)[1];
        }
        if (this.name.startsWith("^")) {
            this.instant = true;
            this.name = this.name.substring(1);
        }
        if (this.value != null && this.value.contains("[")) {
            this.index = this.value.split("\\[")[1].replace("]", "");
            this.name = this.value.split("\\[")[0];
        }
        this.replaceable = tag;
    }

    public String getFallback() {
        return this.fallback;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public String getIndex() {
        return this.index != null ? this.index : "";
    }

    public String getName() {
        return this.name;
    }

    public DenizenNPC getNPC() {
        return this.npc;
    }

    public Player getPlayer() {
        return this.player;
    }

    public String getReplaceable() {
        return this.replaceable;
    }

    public String getType() {
        return this.type != null ? this.type : "";
    }

    public String getValue() {
        return this.value != null ? this.value : "";
    }

    public boolean isInstant() {
        return this.instant;
    }

    public boolean matches(String tagName) {
        return this.name.equalsIgnoreCase(tagName);
    }

    public boolean replaced() {
        return this.replaced;
    }

    public void setReplaceable(String string) {
        this.replaceable = string;
        this.replaced = true;
    }

    public String toString() {
        return this.instant ? "Instant Tag " : "Tag '" + this.name + "." + this.type + "' with value '" + this.value + "'";
    }
}

