/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEngine;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.runnables.Runnable2;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class RuntaskCommand
extends AbstractCommand {
    private static Map<String, Integer> delays = new ConcurrentHashMap<String, Integer>();

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        String id = null;
        String script = null;
        double delay = -1.0;
        boolean instant = false;
        ScriptEngine.QueueType queue = scriptEntry.getPlayer() != null ? ScriptEngine.QueueType.PLAYER_TASK : ScriptEngine.QueueType.NPC;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesScript(arg)) {
                script = aH.getStringFrom(arg);
                dB.echoDebug(dB.Messages.DEBUG_SET_SCRIPT, script);
                continue;
            }
            if (aH.matchesValueArg("DELAY", arg, aH.ArgumentType.Duration)) {
                delay = aH.getSecondsFrom(arg);
                dB.echoDebug("...set DELAY: '%s'", String.valueOf(delay));
                continue;
            }
            if (aH.matchesArg("INSTANT", arg)) {
                instant = true;
                dB.echoDebug("...script will not be queued.");
                continue;
            }
            if (aH.matchesQueueType(arg)) {
                queue = aH.getQueueFrom(arg);
                dB.echoDebug("...set QUEUE: '%s'", queue.toString());
                continue;
            }
            if (aH.matchesValueArg("ID", arg, aH.ArgumentType.Word)) {
                id = aH.getStringFrom(arg);
                dB.echoDebug("...set ID: '%s'", id);
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if ((queue == ScriptEngine.QueueType.PLAYER || queue == ScriptEngine.QueueType.PLAYER_TASK) && scriptEntry.getPlayer() == null) {
            throw new InvalidArgumentsException("Player cannot be null when using a 'Player' Queue.");
        }
        if (queue == ScriptEngine.QueueType.NPC && scriptEntry.getNPC() == null) {
            throw new InvalidArgumentsException("NPC cannot be null when using a 'NPC' Queue.");
        }
        if (script == null) {
            throw new InvalidArgumentsException("Must define a script to be run!");
        }
        if (id == null) {
            id = script;
        }
        scriptEntry.addObject("id", id);
        scriptEntry.addObject("queue", (Object)queue);
        scriptEntry.addObject("delay", delay);
        scriptEntry.addObject("script", script);
        scriptEntry.addObject("instant", instant);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        String script = (String)scriptEntry.getObject("script");
        if ((Double)scriptEntry.getObject("delay") <= 0.0) {
            if (((Boolean)scriptEntry.getObject("instant")).booleanValue()) {
                this.denizen.getScriptEngine().getScriptBuilder().runTaskScriptInstantly(scriptEntry.getPlayer(), scriptEntry.getNPC(), script);
            } else {
                switch ((ScriptEngine.QueueType)((Object)scriptEntry.getObject("queue"))) {
                    case PLAYER: 
                    case PLAYER_TASK: {
                        this.denizen.getScriptEngine().getScriptBuilder().runTaskScript(scriptEntry.getPlayer(), scriptEntry.getNPC(), script);
                        break;
                    }
                    case NPC: {
                        this.denizen.getScriptEngine().getScriptBuilder().runTaskScript(scriptEntry.getNPC(), scriptEntry.getPlayer(), script);
                    }
                }
            }
            if (delays.containsKey(((String)scriptEntry.getObject("id")).toUpperCase())) {
                delays.remove(((String)scriptEntry.getObject("id")).toUpperCase());
            }
        } else {
            String id = ((String)scriptEntry.getObject("id")).toUpperCase();
            long delay = (long)((Double)scriptEntry.getObject("delay") * 20.0);
            scriptEntry.addObject("delay", 0.0);
            dB.echoDebug(dB.Messages.DEBUG_SETTING_DELAYED_TASK, "Run TASK SCRIPT '" + script + "'");
            delays.put(id, this.denizen.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.denizen, (Runnable)new Runnable2<String, ScriptEntry>(script, scriptEntry){

                @Override
                public void run(String script, ScriptEntry scriptEntry) {
                    block2: {
                        dB.log(dB.Messages.DEBUG_RUNNING_DELAYED_TASK, "Run TASK SCRIPT '" + script + "'");
                        try {
                            RuntaskCommand.this.execute(scriptEntry);
                        }
                        catch (CommandExecutionException e) {
                            dB.echoError("Could not run delayed task!");
                            if (!dB.showStackTraces) break block2;
                            e.printStackTrace();
                        }
                    }
                }
            }, delay));
        }
    }

    public static boolean cancelTask(String id) {
        if (delays.containsKey(id.toUpperCase())) {
            block3: {
                try {
                    Bukkit.getServer().getScheduler().cancelTask(delays.get(id.toUpperCase()).intValue());
                }
                catch (Exception e) {
                    dB.echoError("Could not cancel task!");
                    if (!dB.showStackTraces) break block3;
                    e.printStackTrace();
                }
            }
            delays.remove(id.toUpperCase());
            return true;
        }
        return false;
    }
}

