/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.ArrayList;
import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;

public class TeleportCommand
extends AbstractCommand {
    public static final String NPC_ARG = "NPC";

    public void onEnable() {
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        ArrayList<Player> teleportEntities = new ArrayList<Player>();
        ArrayList<NPC> teleportNPCs = new ArrayList<NPC>();
        Location teleportLocation = null;
        if (scriptEntry.getArguments().size() > 3) {
            throw new InvalidArgumentsException("Too many arguments.");
        }
        Boolean teleportPlayer = true;
        for (String thisArg : scriptEntry.getArguments()) {
            if (thisArg.equalsIgnoreCase(NPC_ARG)) {
                teleportNPCs.add(scriptEntry.getNPC().getCitizen());
                teleportPlayer = false;
                dB.echoDebug("...Teleporting the NPC instead of the PLAYER", thisArg);
                continue;
            }
            if (aH.matchesLocation(thisArg)) {
                teleportLocation = aH.getLocationFrom(thisArg);
                dB.echoDebug("...Teleport location now at '%s'.", thisArg);
                continue;
            }
            if (aH.matchesValueArg("TARGETS", thisArg, aH.ArgumentType.Custom)) {
                teleportPlayer = false;
                for (String target : aH.getListFrom(thisArg)) {
                    if (target.matches("\\d+")) {
                        NPC npc = CitizensAPI.getNPCRegistry().getById(Integer.valueOf(target).intValue());
                        if (npc != null) {
                            teleportNPCs.add(npc);
                            continue;
                        }
                        dB.echoError("Unable to find NPC: %s", target);
                    } else {
                        Player player = Bukkit.getPlayer((String)target);
                        if (player != null) {
                            teleportEntities.add(player);
                            continue;
                        }
                        dB.echoError("Unable to find player: %s", target);
                    }
                    dB.echoError("Invalid TARGET '%s'!", target);
                }
                continue;
            }
            dB.echoError("...unable to match '%s'!", thisArg);
        }
        if (teleportPlayer.booleanValue()) {
            teleportEntities.add(scriptEntry.getPlayer());
        }
        scriptEntry.addObject("location", teleportLocation);
        scriptEntry.addObject("entities", teleportEntities);
        scriptEntry.addObject("npcs", teleportNPCs);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Location teleportLocation = (Location)scriptEntry.getObject("location");
        List teleportEntities = (List)scriptEntry.getObject("entities");
        List teleportNPCs = (List)scriptEntry.getObject("npcs");
        if (teleportLocation != null) {
            for (LivingEntity entity : teleportEntities) {
                entity.teleport(teleportLocation);
            }
            for (NPC npc : teleportNPCs) {
                npc.getBukkitEntity().teleport(teleportLocation, PlayerTeleportEvent.TeleportCause.COMMAND);
            }
        }
    }
}

