/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.requirements;

import java.util.ArrayList;
import java.util.List;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.exceptions.RequirementCheckException;
import net.aufdemrand.denizen.scripts.requirements.AbstractRequirement;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.command.exception.RequirementMissingException;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class RequirementChecker {
    private Denizen plugin;

    public RequirementChecker(Denizen denizen) {
        this.plugin = denizen;
    }

    public boolean check(String scriptName, NPC npc, Player player) throws RequirementMissingException {
        String reqMode = this.plugin.getScripts().getString(scriptName + ".REQUIREMENTS.MODE", "NONE");
        List reqList = this.plugin.getScripts().getStringList(scriptName + ".REQUIREMENTS.LIST");
        dB.echoDebug(ChatColor.YELLOW + "CHECK! Now checking '%s'", scriptName);
        int numberMet = 0;
        if (reqList.isEmpty() && !reqMode.equalsIgnoreCase("NONE")) {
            dB.echoError("Non-valid requirements structure at:");
            dB.echoDebug(ChatColor.GRAY + scriptName + ":");
            dB.echoDebug(ChatColor.GRAY + "  Requirements:");
            dB.echoDebug(ChatColor.GRAY + "    Mode: ???");
            dB.echoDebug(ChatColor.GRAY + "    List:");
            dB.echoDebug(ChatColor.GRAY + "    - ???");
            dB.echoDebug("* Check spacing, validate structure and spelling.");
            return false;
        }
        dB.echoDebug("Requirement mode: '%s'", reqMode.toUpperCase());
        if (reqMode.equalsIgnoreCase("NONE") || reqList.isEmpty()) {
            return true;
        }
        boolean firstReqMet = false;
        boolean firstReqChecked = false;
        for (String reqEntry : reqList) {
            boolean negativeRequirement = false;
            if (reqEntry.startsWith("-")) {
                negativeRequirement = true;
                reqEntry = reqEntry.substring(1);
            }
            if (this.plugin.getRequirementRegistry().list().containsKey(reqEntry.split(" ")[0])) {
                AbstractRequirement requirement = this.plugin.getRequirementRegistry().get(reqEntry.split(" ")[0]);
                String[] arguments = null;
                if (reqEntry.split(" ").length > 1) {
                    arguments = this.plugin.getScriptEngine().getScriptBuilder().buildArgs(reqEntry.split(" ", 2)[1]);
                }
                ArrayList<String> argumentList = new ArrayList();
                if (arguments != null) {
                    argumentList = this.plugin.tagManager().fillArguments(arguments, player, this.plugin.getNPCRegistry().getDenizen(npc));
                }
                try {
                    int numArguments;
                    int n = numArguments = arguments == null ? 0 : arguments.length;
                    if (numArguments == 0 && requirement.requirementOptions.REQUIRED_ARGS > 0 || numArguments < requirement.requirementOptions.REQUIRED_ARGS) {
                        throw new RequirementCheckException("");
                    }
                    if (requirement.check(player, this.plugin.getNPCRegistry().getDenizen(npc), scriptName, argumentList) != negativeRequirement) {
                        if (!firstReqChecked) {
                            firstReqMet = true;
                            firstReqChecked = true;
                        }
                        ++numberMet;
                        dB.echoApproval("Checking Requirement '" + requirement.getName() + "'" + " ...requirement met!");
                        continue;
                    }
                    if (!firstReqChecked) {
                        firstReqMet = false;
                        firstReqChecked = true;
                    }
                    dB.echoApproval("Checking Requirement '" + requirement.getName() + "'" + " ...requirement not met!");
                }
                catch (Throwable e) {
                    if (e instanceof RequirementCheckException) {
                        dB.echoError("Woah! Invalid arguments were specified!");
                        dB.echoError("Usage: " + requirement.getUsageHint());
                        continue;
                    }
                    dB.echoError("Woah! An exception has been called for Requirement '" + requirement.getName() + "'!");
                    if (!dB.showStackTraces) {
                        dB.echoError("Enable '/denizen stacktrace' for the nitty-gritty.");
                        continue;
                    }
                    e.printStackTrace();
                }
                continue;
            }
            dB.echoError("Requirement '" + reqEntry.split(" ")[0] + "' not found! Check that the requirement is installed!");
        }
        String[] ModeArgs = reqMode.split(" ");
        if (reqMode.equalsIgnoreCase("ALL") && numberMet == reqList.size()) {
            return true;
        }
        if (ModeArgs[0].equalsIgnoreCase("ANY")) {
            if (ModeArgs.length == 1) {
                return numberMet >= 1;
            }
            return numberMet >= Integer.parseInt(ModeArgs[1]);
        }
        if (ModeArgs[0].equalsIgnoreCase("FIRST") && ModeArgs[3].matches("\\d+")) {
            if (firstReqMet) {
                return numberMet > Integer.parseInt(ModeArgs[3]);
            }
            return false;
        }
        if (!ModeArgs[0].equalsIgnoreCase("ALL")) {
            dB.echoError("Invalid Requirement Mode!");
        }
        return false;
    }
}

