/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.triggers;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.interfaces.DenizenRegistry;
import net.aufdemrand.denizen.interfaces.RegistrationableInstance;
import net.aufdemrand.denizen.scripts.triggers.AbstractTrigger;
import net.aufdemrand.denizen.scripts.triggers.core.ChatTrigger;
import net.aufdemrand.denizen.scripts.triggers.core.ClickTrigger;
import net.aufdemrand.denizen.scripts.triggers.core.DamageTrigger;
import net.aufdemrand.denizen.scripts.triggers.core.ProximityTrigger;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriggerRegistry
implements DenizenRegistry {
    public Denizen denizen;
    private Map<String, AbstractTrigger> instances = new HashMap<String, AbstractTrigger>();
    private Map<Class<? extends AbstractTrigger>, String> classes = new HashMap<Class<? extends AbstractTrigger>, String>();
    Map<Integer, Map<String, Long>> npcCooldown = new ConcurrentHashMap<Integer, Map<String, Long>>();
    Map<String, Map<String, Long>> playerCooldown = new ConcurrentHashMap<String, Map<String, Long>>();

    public TriggerRegistry(Denizen denizen) {
        this.denizen = denizen;
    }

    public boolean checkCooldown(NPC npc, Player player, AbstractTrigger triggerClass, CooldownType cooldownType) {
        switch (cooldownType) {
            case NPC: {
                if (!this.npcCooldown.containsKey(npc.getId())) {
                    return true;
                }
                if (!this.npcCooldown.get(npc.getId()).containsKey(triggerClass.name)) {
                    return true;
                }
                if (System.currentTimeMillis() <= this.npcCooldown.get(npc.getId()).get(triggerClass.name)) break;
                return true;
            }
            case PLAYER: {
                if (!this.playerCooldown.containsKey(player.getName() + "/" + npc.getId())) {
                    return true;
                }
                if (!this.playerCooldown.get(player.getName() + "/" + npc.getId()).containsKey(triggerClass.name)) {
                    return true;
                }
                if (System.currentTimeMillis() <= this.playerCooldown.get(player.getName() + "/" + npc.getId()).get(triggerClass.name)) break;
                return true;
            }
        }
        return false;
    }

    @Override
    public void disableCoreMembers() {
        for (AbstractTrigger member : this.instances.values()) {
            try {
                member.onDisable();
            }
            catch (Exception e) {
                dB.echoError("Unable to disable '" + member.getClass().getName() + "'!");
                if (!dB.showStackTraces) continue;
                e.printStackTrace();
            }
        }
    }

    @Override
    public <T extends RegistrationableInstance> T get(Class<T> clazz) {
        if (this.classes.containsKey(clazz)) {
            return (T)((RegistrationableInstance)clazz.cast(this.instances.get(this.classes.get(clazz))));
        }
        return null;
    }

    @Override
    public AbstractTrigger get(String triggerName) {
        if (this.instances.containsKey(triggerName.toUpperCase())) {
            return this.instances.get(triggerName.toUpperCase());
        }
        return null;
    }

    public Map<String, AbstractTrigger> list() {
        return this.instances;
    }

    @Override
    public boolean register(String triggerName, RegistrationableInstance instance) {
        this.instances.put(triggerName.toUpperCase(), (AbstractTrigger)instance);
        this.classes.put(((AbstractTrigger)instance).getClass(), triggerName.toUpperCase());
        return true;
    }

    @Override
    public void registerCoreMembers() {
        new ClickTrigger().activate().as("Click").withOptions(true, 2.0, CooldownType.PLAYER);
        new DamageTrigger().activate().as("Damage").withOptions(false, 0.5, CooldownType.NPC);
        new ChatTrigger().activate().as("Chat").withOptions(true, 2.0, CooldownType.PLAYER);
        new ProximityTrigger().activate().as("Proximity").withOptions(true, 5.0, 5, CooldownType.PLAYER);
        dB.echoApproval("Loaded core triggers: " + this.instances.keySet().toString());
    }

    public void setCooldown(NPC npc, Player player, AbstractTrigger triggerClass, double seconds, CooldownType type) {
        if (type == CooldownType.NPC) {
            Map<String, Long> triggerMap = new HashMap<String, Long>();
            if (this.npcCooldown.containsKey(npc.getId())) {
                triggerMap = this.npcCooldown.get(npc.getId());
            }
            triggerMap.put(triggerClass.name, System.currentTimeMillis() + (long)(seconds * 1000.0));
            this.npcCooldown.put(npc.getId(), triggerMap);
        } else if (type == CooldownType.PLAYER) {
            Map<String, Long> triggerMap = new HashMap<String, Long>();
            if (this.playerCooldown.containsKey(player.getName() + "/" + npc.getId())) {
                triggerMap = this.playerCooldown.get(player.getName() + "/" + npc.getId());
            }
            triggerMap.put(triggerClass.name, System.currentTimeMillis() + (long)(seconds * 1000.0));
            this.playerCooldown.put(player.getName() + "/" + npc.getId(), triggerMap);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CooldownType {
        NPC,
        PLAYER;

    }
}

