/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.tags.core;

import java.text.DecimalFormat;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.events.ReplaceableTagEvent;
import net.aufdemrand.denizen.flags.FlagManager;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.ChatColor;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class FlagTags
implements Listener {
    Denizen denizen;

    public FlagTags(Denizen denizen) {
        this.denizen = denizen;
        denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)denizen);
    }

    @EventHandler
    public void flagTag(ReplaceableTagEvent event) {
        if (!event.matches("FLAG")) {
            return;
        }
        String flagName = event.getValue().split(":").length > 1 ? event.getValue().split(":")[0].toUpperCase() : event.getValue().toUpperCase();
        String flagFallback = event.getAlternative() != null ? event.getAlternative() : "EMPTY";
        int index = -1;
        ReplaceType replaceType = ReplaceType.ASSTRING;
        if (flagName.contains("\\.")) {
            if (flagName.split("\\.")[1].equalsIgnoreCase("ASSTRING")) {
                replaceType = ReplaceType.ASSTRING;
            } else if (flagName.split("\\.")[1].equalsIgnoreCase("ASCSLIST")) {
                replaceType = ReplaceType.ASLIST;
            } else if (flagName.split("\\.")[1].equalsIgnoreCase("ASINT")) {
                replaceType = ReplaceType.ASINT;
            } else if (flagName.split("\\.")[1].equalsIgnoreCase("ASDOUBLE")) {
                replaceType = ReplaceType.ASDOUBLE;
            } else if (flagName.split("\\.")[1].equalsIgnoreCase("ASMONEY")) {
                replaceType = ReplaceType.ASMONEY;
            }
        }
        if (flagName.contains("[")) {
            index = Integer.valueOf(flagName.split("\\[")[1].replace("]", ""));
            flagName = flagName.split("\\[")[0];
        }
        if (event.getType().toUpperCase().startsWith("G")) {
            if (this.denizen.flagManager().getGlobalFlag(flagName).get(index).isEmpty()) {
                dB.echoDebug(ChatColor.YELLOW + "//REPLACED//" + ChatColor.WHITE + " '%s' flag not found, using fallback!", flagName);
            } else {
                event.setReplaced(this.getReplaceable(this.denizen.flagManager().getGlobalFlag(flagName).get(index), replaceType));
                dB.echoDebug(ChatColor.YELLOW + "//REPLACED//" + ChatColor.WHITE + " '%s' with flag value '" + event.getReplaced() + "'.", flagName);
            }
        } else if (event.getType().toUpperCase().startsWith("D") || event.getType().toUpperCase().startsWith("N")) {
            if (this.denizen.flagManager().getNPCFlag(event.getNPC().getId(), flagName).get(index).isEmpty()) {
                dB.echoDebug(ChatColor.YELLOW + "//REPLACED//" + ChatColor.WHITE + " '%s' flag not found, using fallback!", flagName);
            } else {
                event.setReplaced(this.getReplaceable(this.denizen.flagManager().getNPCFlag(event.getNPC().getId(), flagName).get(index), replaceType));
                dB.echoDebug(ChatColor.YELLOW + "//REPLACED//" + ChatColor.WHITE + " '%s' with flag value '" + event.getReplaced() + "'.", flagName);
            }
        } else if (event.getType().toUpperCase().startsWith("P")) {
            if (this.denizen.flagManager().getPlayerFlag(event.getPlayer().getName(), flagName).get(index).isEmpty()) {
                dB.echoDebug(ChatColor.YELLOW + "//REPLACED//" + ChatColor.WHITE + " '%s' flag not found, using fallback!", flagName);
            } else {
                event.setReplaced(this.getReplaceable(this.denizen.flagManager().getPlayerFlag(event.getPlayer().getName(), flagName).get(index), replaceType));
                dB.echoDebug(ChatColor.YELLOW + "//REPLACED//" + ChatColor.WHITE + " '%s' with flag value '" + event.getReplaced() + "'.", flagName);
            }
        }
    }

    private String getReplaceable(FlagManager.Value flag, ReplaceType replaceType) {
        switch (replaceType) {
            case ASINT: {
                return String.valueOf(flag.asInteger());
            }
            case ASDOUBLE: {
                return String.valueOf(flag.asDouble());
            }
            case ASSTRING: {
                return flag.asString();
            }
            case ASLIST: {
                return String.valueOf(flag.asCommaSeparatedList());
            }
            case ASMONEY: {
                DecimalFormat d = new DecimalFormat("0.00");
                return String.valueOf(d.format(flag.asDouble()));
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ReplaceType {
        ASSTRING,
        ASINT,
        ASDOUBLE,
        ASLIST,
        ASMONEY;

    }
}

