/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands;

import java.util.ArrayList;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.events.ScriptEntryExecuteEvent;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class CommandExecuter {
    private Denizen plugin;

    public CommandExecuter(Denizen denizen) {
        this.plugin = denizen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    public boolean execute(ScriptEntry scriptEntry) {
        block41: {
            if (this.plugin.getCommandRegistry().get(scriptEntry.getCommand()) == null) {
                dB.echoDebug(dB.DebugElement.Header, "Executing command: " + scriptEntry.getCommand());
                dB.echoError(scriptEntry.getCommand() + " is an invalid dScript command! Are you sure the command loaded?");
                dB.echoDebug(dB.DebugElement.Footer);
                return false;
            }
            AbstractCommand command = this.plugin.getCommandRegistry().get(scriptEntry.getCommand());
            if (scriptEntry.getPlayer() != null) {
                dB.echoDebug(dB.DebugElement.Header, "Executing command: " + scriptEntry.getCommand() + "/" + scriptEntry.getPlayer().getName());
            } else {
                dB.echoDebug(dB.DebugElement.Header, "Executing command: " + scriptEntry.getCommand() + "/" + scriptEntry.getNPC().getName());
            }
            boolean keepGoing = true;
            if (command.getOptions().REQUIRED_ARGS > scriptEntry.getArguments().size()) {
                throw new InvalidArgumentsException("");
            }
            scriptEntry.setArguments(this.plugin.tagManager().fillArguments(scriptEntry.getArguments(), scriptEntry));
            ArrayList<String> newArgs = new ArrayList<String>();
            for (String arg : scriptEntry.getArguments()) {
                if (arg.startsWith("PLAYER:")) {
                    boolean foundNewPlayer = false;
                    dB.echoDebug("...replacing the Player link.");
                    for (Player playa : Bukkit.getServer().getOnlinePlayers()) {
                        if (!playa.getName().equalsIgnoreCase(arg.split(":")[1])) continue;
                        foundNewPlayer = true;
                        scriptEntry.setPlayer(playa);
                    }
                    if (foundNewPlayer) {
                        dB.echoDebug("...player set to '%s'.", arg.split(":")[1]);
                    } else {
                        dB.echoDebug("This player is not online! Searching for offline player...");
                        for (Player playa : Bukkit.getServer().getOfflinePlayers()) {
                            if (!playa.getName().equalsIgnoreCase(arg.split(":")[1])) continue;
                            scriptEntry.setPlayer(null);
                            scriptEntry.setOfflinePlayer((OfflinePlayer)playa);
                            foundNewPlayer = true;
                        }
                    }
                    if (foundNewPlayer) {
                        dB.echoDebug("Found an offline player with this name!");
                        dB.echoDebug("   Saving offlinePlayer object.");
                        continue;
                    }
                    dB.echoError("Could not find a valid player!");
                    scriptEntry.setPlayer(null);
                    continue;
                }
                if (arg.startsWith("NPCID:")) {
                    dB.echoDebug("...replacing the NPCID link.");
                    try {
                        if (CitizensAPI.getNPCRegistry().getById(Integer.valueOf(arg.split(":")[1]).intValue()) != null) {
                            scriptEntry.setNPC(this.plugin.getNPCRegistry().getDenizen(CitizensAPI.getNPCRegistry().getById(Integer.valueOf(arg.split(":")[1]).intValue())));
                        }
                        dB.echoDebug("...DenizenNPC set to '%s'.", arg.split(":")[1]);
                    }
                    catch (Exception e) {
                        dB.echoError("NPCID specified could not be matched to a Denizen!");
                        scriptEntry.setNPC(null);
                    }
                    continue;
                }
                newArgs.add(arg);
            }
            scriptEntry.setArguments(newArgs);
            command.parseArgs(scriptEntry);
            Object var13_15 = null;
            if (!keepGoing) break block41;
            try {
                ScriptEntryExecuteEvent event = new ScriptEntryExecuteEvent(scriptEntry.getPlayer(), scriptEntry);
                Bukkit.getServer().getPluginManager().callEvent((Event)event);
                if (event.isAltered()) {
                    scriptEntry = event.getScriptEntry();
                }
                if (!event.isCancelled()) {
                    command.execute(scriptEntry);
                    break block41;
                }
                dB.echoDebug("ScriptEntry has been cancelled.");
            }
            catch (Exception e2) {
                dB.echoError("Woah!! An exception has been called with this command!");
                if (!dB.showStackTraces) {
                    dB.echoError("Enable '/denizen stacktrace' for the nitty-gritty.");
                    break block41;
                }
                e2.printStackTrace();
            }
            break block41;
            {
                catch (InvalidArgumentsException e) {
                    keepGoing = false;
                    dB.echoError("Woah! Invalid arguments were specified!");
                    dB.echoDebug(ChatColor.YELLOW + "+> MESSAGE follows: " + ChatColor.WHITE + "'" + e.getMessage() + "'");
                    dB.echoDebug("Usage: " + command.getUsageHint());
                    dB.echoDebug(dB.DebugElement.Footer);
                    Object var13_16 = null;
                    if (!keepGoing) break block41;
                    try {
                        ScriptEntryExecuteEvent event = new ScriptEntryExecuteEvent(scriptEntry.getPlayer(), scriptEntry);
                        Bukkit.getServer().getPluginManager().callEvent((Event)event);
                        if (event.isAltered()) {
                            scriptEntry = event.getScriptEntry();
                        }
                        if (!event.isCancelled()) {
                            command.execute(scriptEntry);
                            break block41;
                        }
                        dB.echoDebug("ScriptEntry has been cancelled.");
                    }
                    catch (Exception e2) {
                        dB.echoError("Woah!! An exception has been called with this command!");
                        if (!dB.showStackTraces) {
                            dB.echoError("Enable '/denizen stacktrace' for the nitty-gritty.");
                            break block41;
                        }
                        e2.printStackTrace();
                    }
                    break block41;
                }
                catch (Exception e) {
                    keepGoing = false;
                    dB.echoError("Woah! An exception has been called with this command!");
                    if (!dB.showStackTraces) {
                        dB.echoError("Enable '/denizen stacktrace' for the nitty-gritty.");
                    } else {
                        e.printStackTrace();
                    }
                    dB.echoDebug(dB.DebugElement.Footer);
                    Object var13_17 = null;
                    if (!keepGoing) break block41;
                    try {
                        ScriptEntryExecuteEvent event = new ScriptEntryExecuteEvent(scriptEntry.getPlayer(), scriptEntry);
                        Bukkit.getServer().getPluginManager().callEvent((Event)event);
                        if (event.isAltered()) {
                            scriptEntry = event.getScriptEntry();
                        }
                        if (!event.isCancelled()) {
                            command.execute(scriptEntry);
                            break block41;
                        }
                        dB.echoDebug("ScriptEntry has been cancelled.");
                    }
                    catch (Exception e2) {
                        dB.echoError("Woah!! An exception has been called with this command!");
                        if (!dB.showStackTraces) {
                            dB.echoError("Enable '/denizen stacktrace' for the nitty-gritty.");
                            break block41;
                        }
                        e2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                block42: {
                    Object var13_18 = null;
                    if (keepGoing) {
                        try {
                            ScriptEntryExecuteEvent event = new ScriptEntryExecuteEvent(scriptEntry.getPlayer(), scriptEntry);
                            Bukkit.getServer().getPluginManager().callEvent((Event)event);
                            if (event.isAltered()) {
                                scriptEntry = event.getScriptEntry();
                            }
                            if (!event.isCancelled()) {
                                command.execute(scriptEntry);
                            } else {
                                dB.echoDebug("ScriptEntry has been cancelled.");
                            }
                        }
                        catch (Exception e2) {
                            dB.echoError("Woah!! An exception has been called with this command!");
                            if (!dB.showStackTraces) {
                                dB.echoError("Enable '/denizen stacktrace' for the nitty-gritty.");
                                break block42;
                            }
                            e2.printStackTrace();
                        }
                    }
                }
                throw throwable;
            }
        }
        dB.echoDebug(dB.DebugElement.Footer);
        return true;
    }
}

