/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.speech.SpeechContext;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

public class ChatCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        SpeechContext context = new SpeechContext("");
        boolean noTargets = false;
        if (scriptEntry.getNPC() != null) {
            context.setTalker(scriptEntry.getNPC().getEntity());
        }
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesValueArg("TARGET, TARGETS", arg, aH.ArgumentType.Custom)) {
                if (arg.equalsIgnoreCase("none")) {
                    dB.echoDebug("Removed TARGET(s).");
                    noTargets = true;
                }
                for (String target : aH.getListFrom(arg)) {
                    if (aH.getLivingEntityFrom(target) != null) {
                        context.addRecipient(aH.getLivingEntityFrom(target));
                        continue;
                    }
                    dB.echoError("Invalid TARGET: '%s'", target);
                }
                dB.echoDebug("Set TARGET(s).");
                continue;
            }
            if (aH.matchesValueArg("TALKER", arg, aH.ArgumentType.LivingEntity)) {
                String talker = aH.getStringFrom(arg);
                if (talker.startsWith("NPC.") && aH.getLivingEntityFrom(talker) != null) {
                    context.setTalker(aH.getLivingEntityFrom(talker));
                    continue;
                }
                dB.echoError("Invalid TALKER! Perhaps the NPC doesn't exist?");
                continue;
            }
            context.setMessage(arg);
            dB.echoDebug(dB.Messages.DEBUG_SET_TEXT, arg);
        }
        if (!context.hasRecipients() && !noTargets && scriptEntry.getPlayer() != null) {
            context.addRecipient((LivingEntity)scriptEntry.getPlayer());
        }
        if (context.getTalker() == null) {
            throw new InvalidArgumentsException("Must specify a valid TALKER.");
        }
        if (context.getMessage().length() < 1) {
            throw new InvalidArgumentsException("Must specify a message.");
        }
        scriptEntry.addObject("context", context);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        SpeechContext context = (SpeechContext)scriptEntry.getObject("context");
        if (CitizensAPI.getNPCRegistry().isNPC((Entity)context.getTalker().getEntity())) {
            CitizensAPI.getNPCRegistry().getNPC((Entity)context.getTalker().getEntity()).getDefaultSpeechController().speak(context, "chat");
        }
    }
}

