/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class CooldownCommand
extends AbstractCommand {
    private FileConfiguration saves = null;

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        String script = scriptEntry.getScript();
        double duration = -1.0;
        Player player = null;
        CooldownType type = CooldownType.PLAYER;
        if (scriptEntry.getPlayer() != null) {
            player = scriptEntry.getPlayer();
        } else if (scriptEntry.getOfflinePlayer() != null) {
            player = scriptEntry.getOfflinePlayer();
        }
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesDuration(arg) || aH.matchesInteger(arg)) {
                duration = aH.getSecondsFrom(arg);
                dB.echoDebug(dB.Messages.DEBUG_SET_DURATION, aH.getStringFrom(arg));
                continue;
            }
            if (aH.matchesArg("GLOBAL, PLAYER", arg)) {
                type = CooldownType.valueOf(arg.toUpperCase());
                dB.echoDebug(dB.Messages.DEBUG_SET_TYPE, arg);
                continue;
            }
            if (aH.matchesScript(arg)) {
                script = aH.getStringFrom(arg);
                dB.echoDebug(dB.Messages.DEBUG_SET_SCRIPT, script);
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (type == CooldownType.PLAYER && player == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_NO_PLAYER);
        }
        if (script == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_NO_SCRIPT);
        }
        scriptEntry.addObject("script", script);
        scriptEntry.addObject("duration", duration);
        scriptEntry.addObject("type", (Object)type);
        if (type == CooldownType.PLAYER) {
            scriptEntry.addObject("player", player);
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        String script = (String)scriptEntry.getObject("script");
        int duration = ((Double)scriptEntry.getObject("duration")).intValue();
        CooldownType type = (CooldownType)((Object)scriptEntry.getObject("type"));
        if (type == CooldownType.PLAYER) {
            this.setCooldown(((OfflinePlayer)scriptEntry.getObject("player")).getName(), duration, script, false);
        } else {
            this.setCooldown(null, duration, script, true);
        }
    }

    public boolean checkCooldown(String playerName, String scriptName) {
        playerName = playerName.toUpperCase();
        scriptName = scriptName.toUpperCase();
        if (this.saves == null) {
            this.saves = this.denizen.getSaves();
        }
        if (this.saves.contains("Global.Scripts." + scriptName + ".Cooldown Time")) {
            if (System.currentTimeMillis() < this.saves.getLong("Global.Scripts." + scriptName + ".Cooldown Time")) {
                return false;
            }
            this.saves.set("Global.Scripts." + scriptName + ".Cooldown Time", null);
            this.denizen.saveSaves();
        }
        if (!this.saves.contains("Players." + playerName + ".Scripts." + scriptName + ".Cooldown Time")) {
            return true;
        }
        if (System.currentTimeMillis() >= this.saves.getLong("Players." + playerName + ".Scripts." + scriptName + ".Cooldown Time")) {
            this.saves.set("Players." + playerName + ".Scripts." + scriptName + ".Cooldown Time", null);
            this.denizen.saveSaves();
            return true;
        }
        return false;
    }

    public void setCooldown(String playerName, int duration, String scriptName, boolean global) {
        if (playerName != null) {
            playerName = playerName.toUpperCase();
        }
        scriptName = scriptName.toUpperCase();
        if (this.saves == null) {
            this.saves = this.denizen.getSaves();
        }
        if (global) {
            this.saves.set("Global.Scripts." + scriptName + ".Cooldown Time", (Object)(System.currentTimeMillis() + (long)(duration * 1000)));
            this.denizen.saveSaves();
        } else {
            this.saves.set("Players." + playerName + ".Scripts." + scriptName + ".Cooldown Time", (Object)(System.currentTimeMillis() + (long)(duration * 1000)));
            this.denizen.saveSaves();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CooldownType {
        GLOBAL,
        PLAYER;

    }
}

