/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.npc.activities.core;

import java.util.ArrayList;
import net.aufdemrand.denizen.npc.DenizenNPC;
import net.aufdemrand.denizen.npc.activities.core.WanderActivity;
import net.citizensnpcs.api.ai.Goal;
import net.citizensnpcs.api.ai.GoalSelector;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WanderGoal
implements Goal {
    final DenizenNPC denizenNPC;
    final double X;
    final double Y;
    final double Z;
    final int radius;
    final int depth;
    final int delay;
    final float speed;
    final World world;
    final ArrayList<Material> materials;
    final ArrayList<Integer> materialIds;
    final WanderActivity wA;
    Location wanderLocation = null;
    Long cooldownTimer;

    WanderGoal(DenizenNPC npc, Integer radius, Integer depth, Integer delay, float speed, ArrayList<Material> materials, ArrayList<Integer> materialIds, Location bookmark, WanderActivity wA) {
        this.materialIds = materialIds;
        this.materials = materials;
        this.cooldownTimer = 0L;
        this.denizenNPC = npc;
        this.radius = radius;
        this.depth = depth;
        this.delay = delay;
        this.wA = wA;
        this.speed = speed;
        if (bookmark == null) {
            this.X = npc.getLocation().getX();
            this.Y = npc.getLocation().getY();
            this.Z = npc.getLocation().getZ();
            this.world = npc.getWorld();
        } else {
            this.X = bookmark.getX();
            this.Y = bookmark.getY();
            this.Z = bookmark.getZ();
            this.world = bookmark.getWorld();
        }
        this.wanderLocation = wA.getNewLocation(this.X, this.Y, this.Z, this.world, radius, depth);
    }

    public void reset() {
    }

    public void run(GoalSelector goalSelecter) {
        if (this.denizenNPC.getNavigator().isNavigating()) {
            return;
        }
        this.denizenNPC.getNavigator().getDefaultParameters().speedModifier(this.speed);
        this.wanderLocation = this.wA.getNewLocation(this.X, this.Y, this.Z, this.world, this.radius, this.depth);
        Location checkLocation = new Location(this.wanderLocation.getWorld(), this.wanderLocation.getX(), this.wanderLocation.getY() + 2.0, this.wanderLocation.getZ());
        if (checkLocation.getBlock().getType() != Material.AIR) {
            this.wanderLocation = this.wA.getNewLocation(this.X, this.Y, this.Z, this.world, this.radius, this.depth);
            goalSelecter.finish();
            return;
        }
        if (!this.materials.isEmpty()) {
            Boolean move = false;
            for (Material acceptableMaterial : this.materials) {
                if (this.wanderLocation.getBlock().getType() != acceptableMaterial) continue;
                move = true;
            }
            if (this.materialIds.contains(this.wanderLocation.getBlock().getTypeId())) {
                move = true;
            }
            if (move.booleanValue()) {
                this.denizenNPC.getNavigator().setTarget(this.wanderLocation);
            }
            goalSelecter.finish();
        } else {
            this.denizenNPC.getNavigator().setTarget(this.wanderLocation);
            goalSelecter.finish();
        }
    }

    public boolean shouldExecute(GoalSelector arg0) {
        if (!this.denizenNPC.getNavigator().isNavigating()) {
            return this.isCool();
        }
        return false;
    }

    public void cooldown() {
        this.cooldownTimer = System.currentTimeMillis() + (long)(this.delay * 1000);
    }

    public boolean isCool() {
        return this.cooldownTimer < System.currentTimeMillis();
    }
}

