/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.triggers.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.npc.DenizenNPC;
import net.aufdemrand.denizen.npc.traits.TriggerTrait;
import net.aufdemrand.denizen.scripts.ScriptEngine;
import net.aufdemrand.denizen.scripts.ScriptHelper;
import net.aufdemrand.denizen.scripts.triggers.AbstractTrigger;
import net.aufdemrand.denizen.utilities.DenizenPlayer;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChatTrigger
extends AbstractTrigger
implements Listener {
    private String playerMessage;

    @Override
    public void onEnable() {
        this.denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.denizen);
    }

    @EventHandler
    public void chatTrigger(AsyncPlayerChatEvent event) {
        NPC closestNPC = Utilities.getClosestNPC(event.getPlayer().getLocation(), 3);
        if (closestNPC == null) {
            return;
        }
        if (!closestNPC.hasTrait(TriggerTrait.class) || !((TriggerTrait)closestNPC.getTrait(TriggerTrait.class)).isEnabled(this.name)) {
            return;
        }
        if (Settings.CheckLineOfSightWhenChatting() && !closestNPC.getBukkitEntity().hasLineOfSight((Entity)event.getPlayer())) {
            return;
        }
        dB.log("Found a chat-able NPC close-by: " + closestNPC.getName() + "/" + closestNPC.getId() + ". Interrupting chat...");
        if (!((TriggerTrait)closestNPC.getTrait(TriggerTrait.class)).trigger(this, event.getPlayer())) {
            if (Settings.ChatGloballyIfNotInteractable()) {
                dB.echoDebug(ChatColor.YELLOW + "Resuming. " + ChatColor.WHITE + "The NPC is currently cooling down or engaged.");
                return;
            }
            event.setCancelled(true);
            DenizenPlayer.chat(event.getPlayer(), closestNPC, event.getMessage());
        }
        DenizenNPC denizenNPC = this.denizen.getNPCRegistry().getDenizen(closestNPC);
        String theScript = denizenNPC.getInteractScript(event.getPlayer(), this.getClass());
        this.playerMessage = event.getMessage();
        if (this.parse(denizenNPC, event.getPlayer(), theScript)) {
            event.setCancelled(true);
        } else {
            if (!Settings.ChatGloballyIfFailedChatTriggers()) {
                event.setCancelled(true);
                DenizenPlayer.chat(event.getPlayer(), closestNPC, event.getMessage());
                dB.echoDebug(ChatColor.YELLOW + "INFO! " + ChatColor.WHITE + "No matching chat trigger.");
                dB.echoDebug(dB.DebugElement.Footer);
                return;
            }
            dB.echoDebug(ChatColor.YELLOW + "INFO! " + ChatColor.WHITE + "No matching chat trigger... resuming chat.");
            dB.echoDebug(dB.DebugElement.Footer);
        }
    }

    @Override
    public boolean parse(DenizenNPC npc, Player player, String scriptName) {
        Boolean foundTrigger = false;
        ScriptEngine sE = this.denizen.getScriptEngine();
        dB.echoDebug(dB.DebugElement.Header, "Parsing " + this.name + " trigger: " + npc.getName() + "/" + player.getName());
        String theStep = this.sH.getCurrentStep(player, scriptName);
        Map<String, List<String>> triggerMap = this.getChatTriggers(scriptName, theStep);
        for (String triggerStep : triggerMap.keySet()) {
            Boolean foundMatch = true;
            for (String keyWord : triggerMap.get(triggerStep)) {
                keyWord = this.denizen.tagManager().tag(player, npc, keyWord, false);
                dB.echoDebug("Checking keywords...");
                if (this.isKeywordRegex(keyWord).booleanValue()) {
                    Pattern pattern = Pattern.compile(keyWord.substring(6));
                    if (pattern.matcher(this.playerMessage).find()) continue;
                    foundMatch = false;
                    break;
                }
                if (this.playerMessage.toLowerCase().contains(keyWord.toLowerCase())) continue;
                foundMatch = false;
                break;
            }
            if (!foundMatch.booleanValue()) continue;
            dB.echoApproval("Found match.");
            foundTrigger = true;
            ScriptHelper scriptHelper = sE.getScriptHelper();
            StringBuilder stringBuilder = new StringBuilder().append(triggerStep);
            sE.getScriptHelper();
            List<String> scriptContents = scriptHelper.getScriptContents(stringBuilder.append(ScriptHelper.scriptKey).toString());
            if (scriptContents == null || scriptContents.isEmpty()) continue;
            this.sB.queueScriptEntries(player, this.sB.buildScriptEntries(player, npc, scriptContents, scriptName, theStep), ScriptEngine.QueueType.PLAYER);
        }
        return foundTrigger;
    }

    public Map<String, List<String>> getChatTriggers(String scriptName, String stepName) {
        Set keys;
        Pattern triggerPattern = Pattern.compile("\\/([^/]*)\\/");
        String path = (scriptName + ".steps." + stepName + ".chat trigger").toUpperCase();
        HashMap<String, List<String>> triggerMap = new HashMap<String, List<String>>();
        ConfigurationSection config = this.denizen.getScripts().getConfigurationSection(path);
        if (config != null && (keys = config.getKeys(false)) != null) {
            for (String key : keys) {
                String stepKey = (path + "." + key + ".trigger").toUpperCase();
                String triggerValue = this.denizen.getScripts().getString(stepKey);
                if (triggerValue == null || !triggerValue.contains("/")) continue;
                ArrayList<String> keyWords = new ArrayList<String>();
                Matcher matcher = triggerPattern.matcher(triggerValue);
                while (matcher.find()) {
                    String keyWord = matcher.group();
                    keyWords.add(keyWord.substring(1, keyWord.length() - 1));
                }
                triggerMap.put(path + "." + key, keyWords);
            }
        }
        if (triggerMap.isEmpty()) {
            dB.echoDebug(ChatColor.YELLOW + "INFO +> " + ChatColor.WHITE + "No chat triggers found for script '" + scriptName + "' in step '" + stepName + "'.");
        }
        return triggerMap;
    }

    private Boolean isKeywordRegex(String keyWord) {
        return keyWord.toUpperCase().startsWith("REGEX:");
    }
}

