/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen;

import com.herocraftonline.heroes.Heroes;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.aufdemrand.denizen.CommandHandler;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.activities.ActivityEngine;
import net.aufdemrand.denizen.activities.ActivityRegistry;
import net.aufdemrand.denizen.bookmarks.BookmarkHelper;
import net.aufdemrand.denizen.commands.CommandRegistry;
import net.aufdemrand.denizen.commands.Executer;
import net.aufdemrand.denizen.npc.DenizenNPCRegistry;
import net.aufdemrand.denizen.npc.DenizenTrait;
import net.aufdemrand.denizen.npc.SpeechEngine;
import net.aufdemrand.denizen.requirements.GetRequirements;
import net.aufdemrand.denizen.requirements.RequirementRegistry;
import net.aufdemrand.denizen.scripts.ScriptEngine;
import net.aufdemrand.denizen.triggers.TriggerRegistry;
import net.aufdemrand.denizen.utilities.GetPlayer;
import net.aufdemrand.denizen.utilities.GetWorld;
import net.aufdemrand.denizen.utilities.Utilities;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.trait.TraitInfo;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class Denizen
extends JavaPlugin {
    public Economy economy = null;
    public Permission perms = null;
    public Heroes heroes = null;
    private CommandRegistry commandRegistry = new CommandRegistry(this);
    private TriggerRegistry triggerRegistry = new TriggerRegistry(this);
    private RequirementRegistry requirementRegistry = new RequirementRegistry(this);
    private DenizenNPCRegistry denizenNPCRegistry = new DenizenNPCRegistry(this);
    private ActivityRegistry activityRegistry = new ActivityRegistry(this);
    private ScriptEngine scriptEngine = new ScriptEngine(this);
    private SpeechEngine speechEngine = new SpeechEngine(this);
    private ActivityEngine activityEngine = new ActivityEngine(this);
    public Executer executer = new Executer(this);
    public BookmarkHelper bookmarks = new BookmarkHelper(this);
    public Utilities utilities = new Utilities(this);
    public Settings settings = new Settings(this);
    public GetPlayer getPlayer = new GetPlayer(this);
    public GetRequirements getRequirements = new GetRequirements(this);
    public GetWorld getWorld = new GetWorld(this);
    public Boolean debugMode = false;
    public Boolean preciseMode = false;
    public Boolean newbMode = true;
    private FileConfiguration scriptConfig = null;
    private File scriptConfigFile = null;
    private FileConfiguration savesConfig = null;
    private File savesConfigFile = null;
    private FileConfiguration assignmentConfig = null;
    private File assignmentConfigFile = null;
    public boolean showStackTraces = false;
    private CommandHandler commandHandler = new CommandHandler(this);

    public DenizenNPCRegistry getDenizenNPCRegistry() {
        return this.denizenNPCRegistry;
    }

    public ActivityRegistry getActivityRegistry() {
        return this.activityRegistry;
    }

    public ActivityEngine getActivityEngine() {
        return this.activityEngine;
    }

    public RequirementRegistry getRequirementRegistry() {
        return this.requirementRegistry;
    }

    public CommandRegistry getCommandRegistry() {
        return this.commandRegistry;
    }

    public TriggerRegistry getTriggerRegistry() {
        return this.triggerRegistry;
    }

    public SpeechEngine getSpeechEngine() {
        return this.speechEngine;
    }

    public ScriptEngine getScriptEngine() {
        return this.scriptEngine;
    }

    public void onEnable() {
        if (!this.setupEconomy()) {
            this.getLogger().log(Level.SEVERE, "No economy system found! Some commands may produce errors!");
        }
        if (!this.setupPermissions()) {
            this.getLogger().log(Level.SEVERE, "No permissions system found! Some commands may produce errors!");
        }
        if (this.getServer().getPluginManager().getPlugin("Heroes") != null) {
            this.getLogger().log(Level.INFO, "Found HEROES, you can use Heroes-specific commands!");
            this.heroes = (Heroes)this.getServer().getPluginManager().getPlugin("Heroes");
        }
        this.saveDefaultConfig();
        this.reloadConfig();
        this.reloadScripts();
        this.reloadSaves();
        this.reloadAssignments();
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(DenizenTrait.class).withName("denizen"));
        this.commandRegistry.registerCoreCommands();
        this.triggerRegistry.registerCoreTriggers();
        this.activityRegistry.registerCoreActivities();
        this.requirementRegistry.registerCoreRequirements();
        this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                Denizen.this.scriptEngine.runQueues();
            }
        }, (long)this.settings.InteractDelayInTicks(), (long)this.settings.InteractDelayInTicks());
        this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                Denizen.this.activityEngine.scheduleScripts(false);
            }
        }, 1L, 600L);
        this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                Denizen.this.bookmarks.buildLocationTriggerList();
            }
        }, 50L);
        this.getServer().getPluginManager().registerEvents((Listener)this.activityEngine, (Plugin)this);
    }

    public void onDisable() {
        this.getLogger().log(Level.INFO, " v" + this.getDescription().getVersion() + " disabled.");
        Bukkit.getServer().getScheduler().cancelTasks((Plugin)this);
        this.saveSaves();
        HandlerList.unregisterAll((Plugin)this);
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        this.economy = (Economy)rsp.getProvider();
        return this.economy != null;
    }

    private boolean setupPermissions() {
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Permission.class);
        this.perms = (Permission)rsp.getProvider();
        return this.perms != null;
    }

    public void reloadScripts() {
        try {
            this.scriptEngine.helper.ConcatenateScripts();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.scriptConfigFile == null) {
            this.scriptConfigFile = new File(this.getDataFolder(), "read-only-scripts.yml");
        }
        this.scriptConfig = YamlConfiguration.loadConfiguration((File)this.scriptConfigFile);
        InputStream defConfigStream = this.getResource("read-only-scripts.yml");
        if (defConfigStream != null) {
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((InputStream)defConfigStream);
            this.scriptConfig.setDefaults((Configuration)defConfig);
        }
    }

    public FileConfiguration getScripts() {
        if (this.scriptConfig == null) {
            this.reloadScripts();
        }
        return this.scriptConfig;
    }

    public void reloadSaves() {
        if (this.savesConfigFile == null) {
            this.savesConfigFile = new File(this.getDataFolder(), "saves.yml");
        }
        this.savesConfig = YamlConfiguration.loadConfiguration((File)this.savesConfigFile);
        InputStream defConfigStream = this.getResource("saves.yml");
        if (defConfigStream != null) {
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((InputStream)defConfigStream);
            this.savesConfig.setDefaults((Configuration)defConfig);
        }
    }

    public FileConfiguration getSaves() {
        if (this.savesConfig == null) {
            this.reloadSaves();
        }
        return this.savesConfig;
    }

    public void saveSaves() {
        if (this.savesConfig == null || this.savesConfigFile == null) {
            return;
        }
        try {
            this.savesConfig.save(this.savesConfigFile);
        }
        catch (IOException ex) {
            Logger.getLogger(JavaPlugin.class.getName()).log(Level.SEVERE, "Could not save config to " + this.savesConfigFile, ex);
        }
    }

    public void reloadAssignments() {
        if (this.assignmentConfigFile == null) {
            this.assignmentConfigFile = new File(this.getDataFolder(), "assignments.yml");
        }
        this.assignmentConfig = YamlConfiguration.loadConfiguration((File)this.assignmentConfigFile);
        InputStream defConfigStream = this.getResource("assignments.yml");
        if (defConfigStream != null) {
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((InputStream)defConfigStream);
            this.assignmentConfig.setDefaults((Configuration)defConfig);
        }
    }

    public FileConfiguration getAssignments() {
        if (this.assignmentConfig == null) {
            this.reloadAssignments();
        }
        return this.assignmentConfig;
    }

    public CommandHandler getCommandHandler() {
        return this.commandHandler;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String cmdLabel, String[] args) {
        return this.getCommandHandler().onCommand(sender, cmd, cmdLabel, args);
    }
}

