/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.activities;

import java.util.List;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.npc.DenizenNPC;
import net.aufdemrand.denizen.npc.DenizenTrait;
import net.aufdemrand.denizen.runnables.OneItemRunnable;
import net.citizensnpcs.api.event.NPCSpawnEvent;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ActivityEngine
implements Listener {
    Denizen plugin;
    CommandSender cs = null;

    public ActivityEngine(Denizen denizen) {
        this.plugin = denizen;
    }

    @EventHandler
    public void setDefaultActivity(NPCSpawnEvent event) {
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)new OneItemRunnable<NPC>(event.getNPC()){

            @Override
            public void run(NPC theNPC) {
                block3: {
                    try {
                        if (theNPC.hasTrait(DenizenTrait.class)) {
                            ActivityEngine.this.setDefaultActivity(ActivityEngine.this.plugin.getDenizenNPCRegistry().getDenizen(theNPC));
                        }
                    }
                    catch (Exception e) {
                        if (!ActivityEngine.this.plugin.showStackTraces) break block3;
                        e.printStackTrace();
                    }
                }
            }
        }, 30L);
    }

    public void setDefaultActivity(DenizenNPC theDenizen) {
        if (this.plugin.getAssignments().contains("Denizens." + theDenizen.getName() + ".Default Activity")) {
            this.setActivityScript(theDenizen, this.plugin.getAssignments().getString("Denizens." + theDenizen.getName() + ".Default Activity"));
        }
    }

    public void scheduleScripts(boolean forceable) {
        if (this.plugin.getDenizenNPCRegistry().getDenizens().isEmpty()) {
            return;
        }
        for (DenizenNPC theDenizen : this.plugin.getDenizenNPCRegistry().getDenizens().values()) {
            if (forceable) {
                this.plugin.getSaves().set("Denizens." + theDenizen.getName() + "." + theDenizen.getId() + ".Active Activity Script", null);
            }
            if (forceable) {
                this.plugin.getActivityRegistry().removeAllActivities(theDenizen.getCitizensEntity());
            }
            if (!theDenizen.isSpawned()) continue;
            if (forceable) {
                this.setDefaultActivity(theDenizen);
            }
            int denizenTime = Math.round(theDenizen.getWorld().getTime() / 1000L);
            List denizenActivities = this.plugin.getAssignments().getStringList("Denizens." + theDenizen.getName() + ".Scheduled Activities");
            if (denizenActivities.isEmpty()) continue;
            for (String activity : denizenActivities) {
                if (!activity.startsWith(String.valueOf(denizenTime))) continue;
                String activityScript = activity.split(" ", 2)[1];
                if (!this.plugin.getSaves().contains("Denizens." + theDenizen.getName() + "." + theDenizen.getId() + ".Active Activity Script")) {
                    this.setActivityScript(theDenizen, activityScript);
                    continue;
                }
                if (this.plugin.getSaves().getString("Denizens." + theDenizen.getName() + "." + theDenizen.getId() + ".Active Activity Script").toUpperCase().equals(activityScript.toUpperCase())) continue;
                this.setActivityScript(theDenizen, activityScript);
            }
        }
    }

    public void setActivityScript(DenizenNPC theDenizen, String activityScript) {
        if (this.cs == null) {
            this.cs = this.plugin.getServer().getConsoleSender();
        }
        if (this.plugin.debugMode.booleanValue()) {
            this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "+- Updating activity: " + theDenizen.getName() + "/" + theDenizen.getId() + " --------+");
        }
        this.plugin.getSaves().set("Denizens." + theDenizen.getName() + "." + theDenizen.getId() + ".Active Activity Script", (Object)activityScript);
        if (!this.plugin.getScripts().contains(activityScript + ".Activities.List")) {
            if (this.plugin.debugMode.booleanValue()) {
                this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "| " + ChatColor.RED + "ERROR! " + ChatColor.WHITE + "Tried to load the Activity Script '" + activityScript + ".Activities.List', but it couldn't be found. Perhaps something is spelled wrong, or the script doesn't exist?");
            }
            return;
        }
        this.plugin.getActivityRegistry().removeAllActivities(theDenizen.getCitizensEntity());
        for (String activity : this.plugin.getScripts().getStringList(activityScript + ".Activities.List")) {
            String[] arguments = this.plugin.getScriptEngine().helper.buildArgs(activity.split(" ", 3)[2]);
            int priority = Integer.parseInt(activity.split(" ", 3)[0]);
            activity = activity.split(" ", 3)[1];
            this.plugin.getActivityRegistry().addActivity(activity, theDenizen, arguments, priority);
        }
        if (this.plugin.debugMode.booleanValue()) {
            this.cs.sendMessage(ChatColor.LIGHT_PURPLE + "+---------------------+");
        }
    }
}

